/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.lang.reflect.Field;
import java.util.Properties;
import org.mariadb.jdbc.internal.util.OptionUtils;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.constant.HaMode;

public final class DefaultOptions
extends Enum<DefaultOptions> {
    public static final /* enum */ DefaultOptions USER = new DefaultOptions("user", "1.0.0");
    public static final /* enum */ DefaultOptions PASSWORD = new DefaultOptions("password", "1.0.0");
    public static final /* enum */ DefaultOptions CONNECT_TIMEOUT = new DefaultOptions("connectTimeout", 30000, (Integer)0, "1.1.8");
    public static final /* enum */ DefaultOptions PIPE = new DefaultOptions("pipe", "1.1.3");
    public static final /* enum */ DefaultOptions LOCAL_SOCKET = new DefaultOptions("localSocket", "1.1.4");
    public static final /* enum */ DefaultOptions SHARED_MEMORY = new DefaultOptions("sharedMemory", "1.1.4");
    public static final /* enum */ DefaultOptions TCP_NO_DELAY = new DefaultOptions("tcpNoDelay", Boolean.TRUE, "1.0.0");
    public static final /* enum */ DefaultOptions TCP_ABORTIVE_CLOSE = new DefaultOptions("tcpAbortiveClose", Boolean.FALSE, "1.1.1");
    public static final /* enum */ DefaultOptions LOCAL_SOCKET_ADDRESS = new DefaultOptions("localSocketAddress", "1.1.8");
    public static final /* enum */ DefaultOptions SOCKET_TIMEOUT = new DefaultOptions("socketTimeout", new Integer[]{10000, null, null, null, null, null}, (Integer)0, "1.1.8");
    public static final /* enum */ DefaultOptions INTERACTIVE_CLIENT = new DefaultOptions("interactiveClient", Boolean.FALSE, "1.1.8");
    public static final /* enum */ DefaultOptions DUMP_QUERY_ON_EXCEPTION = new DefaultOptions("dumpQueriesOnException", Boolean.TRUE, "1.1.0");
    public static final /* enum */ DefaultOptions USE_OLD_ALIAS_METADATA_BEHAVIOR = new DefaultOptions("useOldAliasMetadataBehavior", Boolean.FALSE, "1.1.9");
    public static final /* enum */ DefaultOptions ALLOW_LOCAL_INFILE = new DefaultOptions("allowLocalInfile", Boolean.TRUE, "1.2.1");
    public static final /* enum */ DefaultOptions SESSION_VARIABLES = new DefaultOptions("sessionVariables", "1.1.0");
    public static final /* enum */ DefaultOptions CREATE_DATABASE_IF_NOT_EXISTS = new DefaultOptions("createDatabaseIfNotExist", Boolean.FALSE, "1.1.8");
    public static final /* enum */ DefaultOptions SERVER_TIMEZONE = new DefaultOptions("serverTimezone", "1.1.8");
    public static final /* enum */ DefaultOptions NULL_CATALOG_MEANS_CURRENT = new DefaultOptions("nullCatalogMeansCurrent", Boolean.TRUE, "1.1.8");
    public static final /* enum */ DefaultOptions TINY_INT_IS_BIT = new DefaultOptions("tinyInt1isBit", Boolean.TRUE, "1.0.0");
    public static final /* enum */ DefaultOptions YEAR_IS_DATE_TYPE = new DefaultOptions("yearIsDateType", Boolean.TRUE, "1.0.0");
    public static final /* enum */ DefaultOptions USE_SSL = new DefaultOptions("useSsl", Boolean.FALSE, "1.1.0");
    public static final /* enum */ DefaultOptions USER_COMPRESSION = new DefaultOptions("useCompression", Boolean.FALSE, "1.0.0");
    public static final /* enum */ DefaultOptions ALLOW_MULTI_QUERIES = new DefaultOptions("allowMultiQueries", Boolean.FALSE, "1.0.0");
    public static final /* enum */ DefaultOptions REWRITE_BATCHED_STATEMENTS = new DefaultOptions("rewriteBatchedStatements", Boolean.FALSE, "1.1.8");
    public static final /* enum */ DefaultOptions TCP_KEEP_ALIVE = new DefaultOptions("tcpKeepAlive", Boolean.TRUE, "1.0.0");
    public static final /* enum */ DefaultOptions TCP_RCV_BUF = new DefaultOptions("tcpRcvBuf", (Integer)null, (Integer)0, "1.0.0");
    public static final /* enum */ DefaultOptions TCP_SND_BUF = new DefaultOptions("tcpSndBuf", (Integer)null, (Integer)0, "1.0.0");
    public static final /* enum */ DefaultOptions SOCKET_FACTORY = new DefaultOptions("socketFactory", "1.0.0");
    public static final /* enum */ DefaultOptions PIN_GLOBAL_TX_TO_PHYSICAL_CONNECTION = new DefaultOptions("pinGlobalTxToPhysicalConnection", Boolean.FALSE, "1.1.8");
    public static final /* enum */ DefaultOptions TRUST_SERVER_CERTIFICATE = new DefaultOptions("trustServerCertificate", Boolean.FALSE, "1.1.1");
    public static final /* enum */ DefaultOptions SERVER_SSL_CERT = new DefaultOptions("serverSslCert", "1.1.3");
    public static final /* enum */ DefaultOptions USE_FRACTIONAL_SECONDS = new DefaultOptions("useFractionalSeconds", Boolean.TRUE, "1.0.0");
    public static final /* enum */ DefaultOptions AUTO_RECONNECT = new DefaultOptions("autoReconnect", Boolean.FALSE, "1.2.0");
    public static final /* enum */ DefaultOptions FAIL_ON_READ_ONLY = new DefaultOptions("failOnReadOnly", Boolean.FALSE, "1.2.0");
    public static final /* enum */ DefaultOptions RETRY_ALL_DOWN = new DefaultOptions("retriesAllDown", 120, (Integer)0, "1.2.0");
    public static final /* enum */ DefaultOptions FAILOVER_LOOP_RETRIES = new DefaultOptions("failoverLoopRetries", 120, (Integer)0, "1.2.0");
    public static final /* enum */ DefaultOptions VALID_CONNECTION_TIMEOUT = new DefaultOptions("validConnectionTimeout", 0, (Integer)0, "1.2.0");
    public static final /* enum */ DefaultOptions LOAD_BALANCE_BLACKLIST_TIMEOUT = new DefaultOptions("loadBalanceBlacklistTimeout", 50, (Integer)0, "1.2.0");
    public static final /* enum */ DefaultOptions CACHEPREPSTMTS = new DefaultOptions("cachePrepStmts", Boolean.TRUE, "1.3.0");
    public static final /* enum */ DefaultOptions PREPSTMTCACHESIZE = new DefaultOptions("prepStmtCacheSize", 250, (Integer)0, "1.3.0");
    public static final /* enum */ DefaultOptions PREPSTMTCACHESQLLIMIT = new DefaultOptions("prepStmtCacheSqlLimit", 2048, (Integer)0, "1.3.0");
    public static final /* enum */ DefaultOptions ASSUREREADONLY = new DefaultOptions("assureReadOnly", Boolean.FALSE, "1.3.0");
    public static final /* enum */ DefaultOptions USELEGACYDATETIMECODE = new DefaultOptions("useLegacyDatetimeCode", Boolean.TRUE, "1.3.0");
    public static final /* enum */ DefaultOptions MAXIMIZEMYSQLCOMPATIBILITY = new DefaultOptions("maximizeMysqlCompatibility", Boolean.FALSE, "1.3.0");
    public static final /* enum */ DefaultOptions USESERVERPREPSTMTS = new DefaultOptions("useServerPrepStmts", Boolean.FALSE, "1.3.0");
    public static final /* enum */ DefaultOptions TRUSTSTORE = new DefaultOptions("trustStore", "1.3.0");
    public static final /* enum */ DefaultOptions TRUST_CERTIFICATE_KEYSTORE_PASSWORD = new DefaultOptions("trustStorePassword", "1.3.0");
    public static final /* enum */ DefaultOptions KEYSTORE = new DefaultOptions("keyStore", "1.3.0");
    public static final /* enum */ DefaultOptions KEYSTORE_PASSWORD = new DefaultOptions("keyStorePassword", "1.3.0");
    public static final /* enum */ DefaultOptions PRIVATE_KEYS_PASSWORD = new DefaultOptions("keyPassword", "1.5.3");
    public static final /* enum */ DefaultOptions ENABLED_SSL_PROTOCOL_SUITES = new DefaultOptions("enabledSslProtocolSuites", "1.5.0");
    public static final /* enum */ DefaultOptions ENABLED_SSL_CIPHER_SUITES = new DefaultOptions("enabledSslCipherSuites", "1.5.0");
    public static final /* enum */ DefaultOptions CONTINUE_BATCH_ON_ERROR = new DefaultOptions("continueBatchOnError", Boolean.TRUE, "1.4.0");
    public static final /* enum */ DefaultOptions JDBCOMPLIANTRUNCATION = new DefaultOptions("jdbcCompliantTruncation", Boolean.TRUE, "1.4.0");
    public static final /* enum */ DefaultOptions CACHE_CALLABLE_STMTS = new DefaultOptions("cacheCallableStmts", Boolean.TRUE, "1.4.0");
    public static final /* enum */ DefaultOptions CALLABLE_STMT_CACHE_SIZE = new DefaultOptions("callableStmtCacheSize", 150, (Integer)0, "1.4.0");
    public static final /* enum */ DefaultOptions CONNECTION_ATTRIBUTES = new DefaultOptions("connectionAttributes", "1.4.0");
    public static final /* enum */ DefaultOptions USE_BATCH_MULTI_SEND = new DefaultOptions("useBatchMultiSend", (Boolean)null, "1.5.0");
    public static final /* enum */ DefaultOptions USE_BATCH_MULTI_SEND_NUMBER = new DefaultOptions("useBatchMultiSendNumber", 100, (Integer)1, "1.5.0");
    public static final /* enum */ DefaultOptions LOGGING = new DefaultOptions("log", Boolean.FALSE, "1.5.0");
    public static final /* enum */ DefaultOptions PROFILESQL = new DefaultOptions("profileSql", Boolean.FALSE, "1.5.0");
    public static final /* enum */ DefaultOptions MAX_QUERY_LOG_SIZE = new DefaultOptions("maxQuerySizeToLog", 1024, (Integer)0, "1.5.0");
    public static final /* enum */ DefaultOptions SLOW_QUERY_TIME = new DefaultOptions("slowQueryThresholdNanos", (Long)null, 0L, "1.5.0");
    public static final /* enum */ DefaultOptions PASSWORD_CHARACTER_ENCODING = new DefaultOptions("passwordCharacterEncoding", "1.5.9");
    public static final /* enum */ DefaultOptions PIPELINE_AUTH = new DefaultOptions("usePipelineAuth", (Boolean)null, "1.6.0");
    public static final /* enum */ DefaultOptions ENABLE_PACKET_DEBUG = new DefaultOptions("enablePacketDebug", Boolean.FALSE, "1.6.0");
    public static final /* enum */ DefaultOptions SSL_HOSTNAME_VERIFICATION = new DefaultOptions("disableSslHostnameVerification", Boolean.FALSE, "2.1.0");
    public static final /* enum */ DefaultOptions USE_BULK_PROTOCOL = new DefaultOptions("useBulkStmts", Boolean.TRUE, "2.1.0");
    public static final /* enum */ DefaultOptions AUTOCOMMIT = new DefaultOptions("autocommit", Boolean.TRUE, "2.2.0");
    public static final /* enum */ DefaultOptions POOL = new DefaultOptions("pool", Boolean.FALSE, "2.2.0");
    public static final /* enum */ DefaultOptions POOL_NAME = new DefaultOptions("poolName", "2.2.0");
    public static final /* enum */ DefaultOptions MAX_POOL_SIZE = new DefaultOptions("maxPoolSize", 8, (Integer)1, "2.2.0");
    public static final /* enum */ DefaultOptions MIN_POOL_SIZE = new DefaultOptions("minPoolSize", (Integer)null, (Integer)0, "2.2.0");
    public static final /* enum */ DefaultOptions MAX_IDLE_TIME = new DefaultOptions("maxIdleTime", 600, (Integer)60, "2.2.0");
    public static final /* enum */ DefaultOptions POOL_VALID_MIN_DELAY = new DefaultOptions("poolValidMinDelay", 1000, (Integer)0, "2.2.0");
    public static final /* enum */ DefaultOptions STATIC_GLOBAL = new DefaultOptions("staticGlobal", Boolean.FALSE, "2.2.0");
    public static final /* enum */ DefaultOptions REGISTER_POOL_JMX = new DefaultOptions("registerJmxPool", Boolean.TRUE, "2.2.0");
    public static final /* enum */ DefaultOptions USE_RESET_CONNECTION = new DefaultOptions("useResetConnection", Boolean.FALSE, "2.2.0");
    public static final /* enum */ DefaultOptions ALLOW_MASTER_DOWN = new DefaultOptions("allowMasterDownConnection", Boolean.FALSE, "2.2.0");
    public static final /* enum */ DefaultOptions GALERA_ALLOWED_STATE = new DefaultOptions("galeraAllowedState", "2.2.5");
    private final String optionName;
    private final Object objType;
    private final Object defaultValue;
    private final Object minValue;
    private final Object maxValue;
    private final String implementationVersion;
    private static final /* synthetic */ DefaultOptions[] $VALUES;

    public static DefaultOptions[] values() {
        return (DefaultOptions[])$VALUES.clone();
    }

    public static DefaultOptions valueOf(String name) {
        return Enum.valueOf(DefaultOptions.class, name);
    }

    private DefaultOptions(String optionName, String implementationVersion) {
        this.optionName = optionName;
        this.implementationVersion = implementationVersion;
        this.objType = String.class;
        this.defaultValue = null;
        this.minValue = null;
        this.maxValue = null;
    }

    private DefaultOptions(String optionName, String defaultValue, String implementationVersion) {
        this.optionName = optionName;
        this.implementationVersion = implementationVersion;
        this.objType = String.class;
        this.defaultValue = defaultValue;
        this.minValue = null;
        this.maxValue = null;
    }

    private DefaultOptions(String optionName, Boolean defaultValue, String implementationVersion) {
        this.optionName = optionName;
        this.objType = Boolean.class;
        this.defaultValue = defaultValue;
        this.implementationVersion = implementationVersion;
        this.minValue = null;
        this.maxValue = null;
    }

    private DefaultOptions(String optionName, Integer defaultValue, Integer minValue, String implementationVersion) {
        this.optionName = optionName;
        this.objType = Integer.class;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = Integer.MAX_VALUE;
        this.implementationVersion = implementationVersion;
    }

    private DefaultOptions(String optionName, Long defaultValue, Long minValue, String implementationVersion) {
        this.optionName = optionName;
        this.objType = Long.class;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = Long.MAX_VALUE;
        this.implementationVersion = implementationVersion;
    }

    private DefaultOptions(String optionName, Integer[] defaultValue, Integer minValue, String implementationVersion) {
        this.optionName = optionName;
        this.objType = Integer.class;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = Integer.MAX_VALUE;
        this.implementationVersion = implementationVersion;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public static Options defaultValues(HaMode haMode) {
        return DefaultOptions.parse(haMode, "", new Properties());
    }

    public static Options defaultValues(HaMode haMode, boolean pool) {
        Properties properties = new Properties();
        properties.setProperty("pool", String.valueOf(pool));
        Options options = DefaultOptions.parse(haMode, "", properties);
        DefaultOptions.optionCoherenceValidation(options);
        return options;
    }

    public static void parse(HaMode haMode, String urlParameters, Options options) {
        Properties prop = new Properties();
        DefaultOptions.parse(haMode, urlParameters, prop, options);
        DefaultOptions.optionCoherenceValidation(options);
    }

    private static Options parse(HaMode haMode, String urlParameters, Properties properties) {
        Options options = DefaultOptions.parse(haMode, urlParameters, properties, null);
        DefaultOptions.optionCoherenceValidation(options);
        return options;
    }

    public static Options parse(HaMode haMode, String urlParameters, Properties properties, Options options) {
        if (urlParameters != null && !urlParameters.isEmpty()) {
            String[] parameters;
            for (String parameter : parameters = urlParameters.split("&")) {
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    if (properties.containsKey(parameter)) continue;
                    properties.setProperty(parameter, "");
                    continue;
                }
                if (properties.containsKey(parameter.substring(0, pos))) continue;
                properties.setProperty(parameter.substring(0, pos), parameter.substring(pos + 1));
            }
        }
        return DefaultOptions.parse(haMode, properties, options);
    }

    private static Options parse(HaMode haMode, Properties properties, Options paramOptions) {
        Options options = paramOptions != null ? paramOptions : new Options();
        try {
            for (String key : properties.stringPropertyNames()) {
                Number value;
                String propertyValue = properties.getProperty(key);
                DefaultOptions o = OptionUtils.OPTIONS_MAP.get(key);
                if (o == null || propertyValue == null) continue;
                Field field = Options.class.getField(o.optionName);
                if (o.objType.equals(String.class)) {
                    field.set(options, propertyValue);
                    continue;
                }
                if (o.objType.equals(Boolean.class)) {
                    String lower = propertyValue.toLowerCase();
                    if ("".equals(lower) || "1".equals(lower) || "true".equals(lower)) {
                        field.set(options, Boolean.TRUE);
                        continue;
                    }
                    if ("0".equals(lower) || "false".equals(lower)) {
                        field.set(options, Boolean.FALSE);
                        continue;
                    }
                    throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be boolean (true/false or 0/1) was \"" + propertyValue + "\"");
                }
                if (o.objType.equals(Integer.class)) {
                    try {
                        value = Integer.parseInt(propertyValue);
                        assert (o.minValue != null);
                        assert (o.maxValue != null);
                        if (((Integer)value).compareTo((Integer)o.minValue) < 0 || ((Integer)value).compareTo((Integer)o.maxValue) > 0) {
                            throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be greater or equal to " + o.minValue + ((Integer)o.maxValue != Integer.MAX_VALUE ? " and smaller than " + o.maxValue : " ") + ", was \"" + propertyValue + "\"");
                        }
                        field.set(options, value);
                        continue;
                    }
                    catch (NumberFormatException n) {
                        throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be Integer, was \"" + propertyValue + "\"");
                    }
                }
                if (!o.objType.equals(Long.class)) continue;
                try {
                    value = Long.parseLong(propertyValue);
                    assert (o.minValue != null);
                    assert (o.maxValue != null);
                    if (((Long)value).compareTo((Long)o.minValue) < 0 || ((Long)value).compareTo((Long)o.maxValue) > 0) {
                        throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be greater or equal to " + o.minValue + ((Long)o.maxValue != Long.MAX_VALUE ? " and smaller than " + o.maxValue : " ") + ", was \"" + propertyValue + "\"");
                    }
                    field.set(options, value);
                }
                catch (NumberFormatException n) {
                    throw new IllegalArgumentException("Optional parameter " + o.optionName + " must be Long, was \"" + propertyValue + "\"");
                }
            }
            if (options.socketTimeout == null) {
                options.socketTimeout = ((Integer[])DefaultOptions.SOCKET_TIMEOUT.defaultValue)[haMode.ordinal()];
            }
        }
        catch (NoSuchFieldException n) {
            n.printStackTrace();
        }
        catch (IllegalAccessException n) {
            n.printStackTrace();
        }
        catch (SecurityException s) {
            throw new IllegalArgumentException("Security too restrictive : " + s.getMessage());
        }
        return options;
    }

    public static void optionCoherenceValidation(Options options) {
        if (options.rewriteBatchedStatements) {
            options.useServerPrepStmts = false;
        }
        if (options.pipe != null) {
            options.useBatchMultiSend = false;
            options.usePipelineAuth = false;
        }
        if (options.pool) {
            options.minPoolSize = options.minPoolSize == null ? options.maxPoolSize : Math.min(options.minPoolSize, options.maxPoolSize);
        }
    }

    public static void propertyString(Options options, HaMode haMode, StringBuilder sb) {
        try {
            boolean first = true;
            for (DefaultOptions o : DefaultOptions.values()) {
                Object value = Options.class.getField(o.optionName).get(options);
                if (value == null || value.equals(o.defaultValue)) continue;
                if (first) {
                    first = false;
                    sb.append('?');
                } else {
                    sb.append('&');
                }
                sb.append(o.optionName).append('=');
                if (o.objType.equals(String.class)) {
                    sb.append((String)value);
                    continue;
                }
                if (o.objType.equals(Boolean.class)) {
                    sb.append(((Boolean)value).toString());
                    continue;
                }
                if (o.objType.equals(Integer.class)) {
                    sb.append((Integer)value);
                    continue;
                }
                if (!o.objType.equals(Long.class)) continue;
                sb.append((Long)value);
            }
        }
        catch (NoSuchFieldException n) {
            n.printStackTrace();
        }
        catch (IllegalAccessException n) {
            n.printStackTrace();
        }
    }

    static {
        $VALUES = new DefaultOptions[]{USER, PASSWORD, CONNECT_TIMEOUT, PIPE, LOCAL_SOCKET, SHARED_MEMORY, TCP_NO_DELAY, TCP_ABORTIVE_CLOSE, LOCAL_SOCKET_ADDRESS, SOCKET_TIMEOUT, INTERACTIVE_CLIENT, DUMP_QUERY_ON_EXCEPTION, USE_OLD_ALIAS_METADATA_BEHAVIOR, ALLOW_LOCAL_INFILE, SESSION_VARIABLES, CREATE_DATABASE_IF_NOT_EXISTS, SERVER_TIMEZONE, NULL_CATALOG_MEANS_CURRENT, TINY_INT_IS_BIT, YEAR_IS_DATE_TYPE, USE_SSL, USER_COMPRESSION, ALLOW_MULTI_QUERIES, REWRITE_BATCHED_STATEMENTS, TCP_KEEP_ALIVE, TCP_RCV_BUF, TCP_SND_BUF, SOCKET_FACTORY, PIN_GLOBAL_TX_TO_PHYSICAL_CONNECTION, TRUST_SERVER_CERTIFICATE, SERVER_SSL_CERT, USE_FRACTIONAL_SECONDS, AUTO_RECONNECT, FAIL_ON_READ_ONLY, RETRY_ALL_DOWN, FAILOVER_LOOP_RETRIES, VALID_CONNECTION_TIMEOUT, LOAD_BALANCE_BLACKLIST_TIMEOUT, CACHEPREPSTMTS, PREPSTMTCACHESIZE, PREPSTMTCACHESQLLIMIT, ASSUREREADONLY, USELEGACYDATETIMECODE, MAXIMIZEMYSQLCOMPATIBILITY, USESERVERPREPSTMTS, TRUSTSTORE, TRUST_CERTIFICATE_KEYSTORE_PASSWORD, KEYSTORE, KEYSTORE_PASSWORD, PRIVATE_KEYS_PASSWORD, ENABLED_SSL_PROTOCOL_SUITES, ENABLED_SSL_CIPHER_SUITES, CONTINUE_BATCH_ON_ERROR, JDBCOMPLIANTRUNCATION, CACHE_CALLABLE_STMTS, CALLABLE_STMT_CACHE_SIZE, CONNECTION_ATTRIBUTES, USE_BATCH_MULTI_SEND, USE_BATCH_MULTI_SEND_NUMBER, LOGGING, PROFILESQL, MAX_QUERY_LOG_SIZE, SLOW_QUERY_TIME, PASSWORD_CHARACTER_ENCODING, PIPELINE_AUTH, ENABLE_PACKET_DEBUG, SSL_HOSTNAME_VERIFICATION, USE_BULK_PROTOCOL, AUTOCOMMIT, POOL, POOL_NAME, MAX_POOL_SIZE, MIN_POOL_SIZE, MAX_IDLE_TIME, POOL_VALID_MIN_DELAY, STATIC_GLOBAL, REGISTER_POOL_JMX, USE_RESET_CONNECTION, ALLOW_MASTER_DOWN, GALERA_ALLOWED_STATE};
    }
}

