/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pdf.PDFUtils;

public class PDFTextExtractor {
    private Blob pdfBlob;
    private String password;
    private String extractedAllAsString;
    private static final String END_OF_LINE = "\n";

    public PDFTextExtractor(Blob inBlob) {
        this.pdfBlob = inBlob;
    }

    public PDFTextExtractor(DocumentModel inDoc, String inXPath) {
        if (StringUtils.isBlank((CharSequence)inXPath)) {
            inXPath = "file:content";
        }
        this.pdfBlob = (Blob)inDoc.getPropertyValue(inXPath);
    }

    public String getAllExtractedLines() throws NuxeoException {
        if (this.extractedAllAsString == null) {
            try (PDDocument pdfDoc = PDFUtils.load(this.pdfBlob, this.password);){
                PDFTextStripper stripper = new PDFTextStripper();
                this.extractedAllAsString = stripper.getText(pdfDoc);
            }
            catch (IOException e) {
                throw new NuxeoException("Failed to handle the pdf", (Throwable)e);
            }
        }
        return this.extractedAllAsString;
    }

    public String extractLineOf(String inString) throws IOException {
        String extractedLine = null;
        int lineBegining = this.getAllExtractedLines().indexOf(inString);
        if (lineBegining != -1) {
            int lineEnd = this.getAllExtractedLines().indexOf(END_OF_LINE, lineBegining);
            extractedLine = this.getAllExtractedLines().substring(lineBegining, lineEnd).trim();
        }
        return extractedLine;
    }

    public String extractLastPartOfLine(String string) throws IOException {
        String extractedLine = this.extractLineOf(string);
        if (extractedLine != null) {
            return extractedLine.substring(string.length(), extractedLine.length());
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

