/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.io.IOException;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.pdf.PDFPageNumbering;

@Operation(id="PDF.AddPageNumbers", category="Conversion", label="PDF: Add Page Numbers", description="Add the page numbers to the PDF, using the misc parameters. If the PDF is encrypted, a password is required.")
public class PDFAddPageNumbersOperation {
    public static final String ID = "PDF.AddPageNumbers";
    @Param(name="startAtPage", required=false, values={"1"})
    private long startAtPage = 1L;
    @Param(name="startAtNumber", required=false, values={"1"})
    private long startAtNumber = 1L;
    @Param(name="position", required=false, widget="Option", values={"Bottom right", "Bottom center", "Bottom left", "Top right", "Top center", "Top left"})
    private String position = "Bottom right";
    @Param(name="fontName", required=false, values={"Helvetica"})
    private String fontName = "Helvetica";
    @Param(name="fontSize", required=false, values={"16"})
    private long fontSize = 16L;
    @Param(name="hex255Color", required=false, values={"0xffffff"})
    private String hex255Color = "0xffffff";
    @Param(name="password", required=false)
    protected String password = null;

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob inBlob) throws IOException, COSVisitorException {
        PDFPageNumbering.PAGE_NUMBER_POSITION pos;
        switch (this.position.toLowerCase()) {
            case "bottom center": {
                pos = PDFPageNumbering.PAGE_NUMBER_POSITION.BOTTOM_CENTER;
                break;
            }
            case "bottom left": {
                pos = PDFPageNumbering.PAGE_NUMBER_POSITION.BOTTOM_LEFT;
                break;
            }
            case "top right": {
                pos = PDFPageNumbering.PAGE_NUMBER_POSITION.TOP_RIGHT;
                break;
            }
            case "top center": {
                pos = PDFPageNumbering.PAGE_NUMBER_POSITION.TOP_CENTER;
                break;
            }
            case "top left": {
                pos = PDFPageNumbering.PAGE_NUMBER_POSITION.TOP_LEFT;
                break;
            }
            default: {
                pos = PDFPageNumbering.PAGE_NUMBER_POSITION.BOTTOM_RIGHT;
            }
        }
        PDFPageNumbering pn = new PDFPageNumbering(inBlob);
        pn.setPassword(this.password);
        Blob result = pn.addPageNumbers((int)this.startAtPage, (int)this.startAtNumber, this.fontName, this.fontSize, this.hex255Color, pos);
        result.setFilename(inBlob.getFilename());
        return result;
    }
}

