/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.pdf.PDFInfo;

@Operation(id="PDF.ExtractInfo", category="Document", label="PDF: Extract Info", description="Extract the info of the PDF stored in <code>xpath</code> and put it in the fields referenced by <code>properties</code>. <code>properties</code> is a <code>key=value</code> list (one key-value pair/line, where <code>key</code> is the xpath of the destination field and <code>value</code> is the exact label (case sensitive) as returned by the PageExtractor (see this operation documentation). If there is no blob or the blob is not a PDF, all the values referenced in <code>properties</code> are cleared (set to empty string, 0, ...).")
public class PDFExtractInfoOperation {
    public static final String ID = "PDF.ExtractInfo";
    @Context
    protected CoreSession session;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";
    @Param(name="properties", required=false)
    protected Properties properties;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel inDoc) throws IOException {
        Blob theBlob;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if ((theBlob = (Blob)inDoc.getPropertyValue(this.xpath)) == null || theBlob.getMimeType() != null && !theBlob.getMimeType().equals("application/pdf")) {
            for (String inXPath : this.properties.keySet()) {
                inDoc.setPropertyValue(inXPath, (Serializable)((Object)""));
            }
            if (this.save) {
                this.session.saveDocument(inDoc);
            }
        } else {
            PDFInfo info = new PDFInfo(inDoc);
            inDoc = info.toFields(inDoc, (HashMap<String, String>)this.properties, this.save, this.session);
        }
        return inDoc;
    }
}

