/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.io.IOException;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pdf.PDFMerge;

@Operation(id="PDF.MergeWithDocs", category="Conversion", label="PDF: Merge with Document(s)", description="The input document(s) always is(are) the first PDFs, and their PDF is read in the <code>xpath</code> field (but it is ok for the input doc to have no blob). The operation appends the blob referenced in the <code>toAppendVarName</code> Context variable. It then appends all the blobs stored in the <code>toAppendListVarName</code> Context variable. It then append the blobs stored in the docs whose IDs are passed in <code>toAppendDocIDsVarName</code> (the same <code>xpath</code> is used). Returns the final PDF.")
public class PDFMergeDocumentsOperation {
    public static final String ID = "PDF.MergeWithDocs";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";
    @Param(name="toAppendVarName", required=false)
    protected String toAppendVarName = "";
    @Param(name="toAppendListVarName", required=false)
    protected String toAppendListVarName = "";
    @Param(name="toAppendDocIDsVarName", required=false)
    protected String toAppendDocIDsVarName = "";
    @Param(name="fileName", required=false)
    protected String fileName = "";
    @Param(name="pdfTitle", required=false)
    protected String pdfTitle = "";
    @Param(name="pdfSubject", required=false)
    protected String pdfSubject = "";
    @Param(name="pdfAuthor", required=false)
    protected String pdfAuthor = "";

    @OperationMethod
    public Blob run(DocumentModel inDoc) throws NuxeoException {
        PDFMerge pdfm = new PDFMerge(inDoc, this.xpath);
        return this.doMerge(pdfm);
    }

    @OperationMethod
    public Blob run(DocumentModelList inDocs) throws NuxeoException {
        PDFMerge pdfm = new PDFMerge(inDocs, this.xpath);
        return this.doMerge(pdfm);
    }

    protected Blob doMerge(PDFMerge inMergeTool) throws NuxeoException {
        if (this.toAppendVarName != null && !this.toAppendVarName.isEmpty()) {
            inMergeTool.addBlob((Blob)this.ctx.get((Object)this.toAppendVarName));
        }
        if (this.toAppendListVarName != null && !this.toAppendListVarName.isEmpty()) {
            if (this.ctx.get((Object)this.toAppendListVarName) instanceof BlobList) {
                inMergeTool.addBlobs((BlobList)this.ctx.get((Object)this.toAppendListVarName));
            } else {
                throw new NuxeoException(this.ctx.get((Object)this.toAppendListVarName).getClass() + " is not a Collection");
            }
        }
        if (this.toAppendDocIDsVarName != null && !this.toAppendDocIDsVarName.isEmpty()) {
            if (this.ctx.get((Object)this.toAppendDocIDsVarName) instanceof String[]) {
                inMergeTool.addBlobs((String[])this.ctx.get((Object)this.toAppendDocIDsVarName), this.xpath, this.session);
            } else {
                throw new NuxeoException(this.ctx.get((Object)this.toAppendDocIDsVarName).getClass() + " is not a String[]");
            }
        }
        try {
            return inMergeTool.merge(this.fileName, this.pdfTitle, this.pdfSubject, this.pdfAuthor);
        }
        catch (IOException | COSVisitorException e) {
            throw new NuxeoException(e);
        }
    }
}

