/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.service;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.Overlay;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pdf.PDFUtils;
import org.nuxeo.ecm.platform.pdf.service.PDFTransformationService;
import org.nuxeo.ecm.platform.pdf.service.watermark.WatermarkProperties;
import org.nuxeo.runtime.model.DefaultComponent;

public class PDFTransformationServiceImpl
extends DefaultComponent
implements PDFTransformationService {
    protected static final Log log = LogFactory.getLog(PDFTransformationServiceImpl.class);
    protected static final String MIME_TYPE = "application/pdf";

    @Override
    public WatermarkProperties getDefaultProperties() {
        return new WatermarkProperties();
    }

    @Override
    public Blob applyTextWatermark(Blob input, String text, WatermarkProperties properties) {
        Blob blob;
        block15: {
            PDExtendedGraphicsState extendedGraphicsState = new PDExtendedGraphicsState();
            extendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)properties.getAlphaColor()));
            PDDocument pdfDoc = PDDocument.load((InputStream)input.getStream());
            try {
                PDType1Font font = PDType1Font.getStandardFont((String)properties.getFontFamily());
                float watermarkWidth = (float)((double)font.getStringWidth(text) * properties.getFontSize() / 1000.0);
                int[] rgb = PDFUtils.hex255ToRGB(properties.getHex255Color());
                for (PDPage page : pdfDoc.getDocumentCatalog().getAllPages()) {
                    PDRectangle pageSize = page.findMediaBox();
                    PDResources resources = page.findResources();
                    HashMap<String, PDExtendedGraphicsState> graphicsStates = resources.getGraphicsStates();
                    if (graphicsStates == null) {
                        graphicsStates = new HashMap<String, PDExtendedGraphicsState>();
                    }
                    graphicsStates.put("TransparentState", extendedGraphicsState);
                    resources.setGraphicsStates(graphicsStates);
                    try (PDPageContentStream contentStream = new PDPageContentStream(pdfDoc, page, true, true, true);){
                        contentStream.beginText();
                        contentStream.setFont((PDFont)font, (float)properties.getFontSize());
                        contentStream.appendRawCommands("/TransparentState gs\n");
                        contentStream.setNonStrokingColor(rgb[0], rgb[1], rgb[2]);
                        Point2D position = this.computeTranslationVector(pageSize.getWidth(), watermarkWidth, pageSize.getHeight(), properties.getFontSize(), properties);
                        contentStream.setTextRotation(Math.toRadians(properties.getRotation()), position.getX(), position.getY());
                        contentStream.drawString(text);
                        contentStream.endText();
                    }
                }
                blob = this.saveInTempFile(pdfDoc);
                if (pdfDoc == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (pdfDoc != null) {
                        try {
                            pdfDoc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | COSVisitorException e) {
                    throw new NuxeoException(e);
                }
            }
            pdfDoc.close();
        }
        return blob;
    }

    @Override
    public Blob applyImageWatermark(Blob input, Blob watermark, WatermarkProperties properties) {
        Blob blob;
        block15: {
            PDExtendedGraphicsState extendedGraphicsState = new PDExtendedGraphicsState();
            extendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)properties.getAlphaColor()));
            PDDocument pdfDoc = PDDocument.load((InputStream)input.getStream());
            try {
                BufferedImage image = ImageIO.read(watermark.getStream());
                PDPixelMap ximage = new PDPixelMap(pdfDoc, image);
                for (PDPage page : pdfDoc.getDocumentCatalog().getAllPages()) {
                    PDRectangle pageSize = page.findMediaBox();
                    PDResources resources = page.findResources();
                    HashMap<String, PDExtendedGraphicsState> graphicsStates = resources.getGraphicsStates();
                    if (graphicsStates == null) {
                        graphicsStates = new HashMap<String, PDExtendedGraphicsState>();
                    }
                    graphicsStates.put("TransparentState", extendedGraphicsState);
                    resources.setGraphicsStates(graphicsStates);
                    try (PDPageContentStream contentStream = new PDPageContentStream(pdfDoc, page, true, true);){
                        contentStream.appendRawCommands("/TransparentState gs\n");
                        contentStream.endMarkedContentSequence();
                        double watermarkWidth = (double)ximage.getWidth() * properties.getScale();
                        double watermarkHeight = (double)ximage.getHeight() * properties.getScale();
                        Point2D position = this.computeTranslationVector(pageSize.getWidth(), watermarkWidth, pageSize.getHeight(), watermarkHeight, properties);
                        contentStream.drawXObject((PDXObject)ximage, (float)position.getX(), (float)position.getY(), (float)watermarkWidth, (float)watermarkHeight);
                    }
                }
                blob = this.saveInTempFile(pdfDoc);
                if (pdfDoc == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (pdfDoc != null) {
                        try {
                            pdfDoc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | COSVisitorException e) {
                    throw new NuxeoException(e);
                }
            }
            pdfDoc.close();
        }
        return blob;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob overlayPDF(Blob input, Blob overlayBlob) {
        try (PDDocument pdfDoc = PDDocument.load((InputStream)input.getStream());){
            Blob blob;
            block14: {
                PDDocument pdfOverlayDoc = PDDocument.load((InputStream)overlayBlob.getStream());
                try {
                    Overlay overlay = new Overlay();
                    overlay.overlay(pdfOverlayDoc, pdfDoc);
                    blob = this.saveInTempFile(pdfDoc);
                    if (pdfOverlayDoc == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pdfOverlayDoc != null) {
                        try {
                            pdfOverlayDoc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pdfOverlayDoc.close();
            }
            return blob;
        }
        catch (IOException | COSVisitorException e) {
            throw new NuxeoException(e);
        }
    }

    public Point2D computeTranslationVector(double pageWidth, double watermarkWidth, double pageHeight, double watermarkHeight, WatermarkProperties properties) {
        double yTranslation;
        double xTranslation;
        double xRotationOffset = 0.0;
        double yRotationOffset = 0.0;
        if (properties.getRotation() != 0) {
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(0.0, -watermarkHeight, watermarkWidth, watermarkHeight);
            AffineTransform at = AffineTransform.getRotateInstance(-Math.toRadians(properties.getRotation()), 0.0, 0.0);
            Shape shape = at.createTransformedShape(rectangle2D);
            Rectangle2D rotated = shape.getBounds2D();
            watermarkWidth = rotated.getWidth();
            xRotationOffset = !properties.isInvertX() || properties.isRelativeCoordinates() ? -rotated.getX() : rotated.getX();
            watermarkHeight = rotated.getHeight();
            yRotationOffset = !properties.isInvertY() || properties.isRelativeCoordinates() ? rotated.getY() + rotated.getHeight() : -(rotated.getY() + rotated.getHeight());
        }
        if (properties.isRelativeCoordinates()) {
            xTranslation = (pageWidth - watermarkWidth) * properties.getxPosition() + xRotationOffset;
            yTranslation = (pageHeight - watermarkHeight) * properties.getyPosition() + yRotationOffset;
        } else {
            xTranslation = properties.getxPosition() + xRotationOffset;
            yTranslation = properties.getyPosition() + yRotationOffset;
            if (properties.isInvertX()) {
                xTranslation = pageWidth - watermarkWidth - xTranslation;
            }
            if (properties.isInvertY()) {
                yTranslation = pageHeight - watermarkHeight - yTranslation;
            }
        }
        return new Point2D.Double(xTranslation, yTranslation);
    }

    protected Blob saveInTempFile(PDDocument PdfDoc) throws IOException, COSVisitorException {
        Blob blob = Blobs.createBlobWithExtension((String)".pdf");
        blob.setMimeType(MIME_TYPE);
        PdfDoc.save(blob.getFile());
        return blob;
    }
}

