/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.htmlsanitizer;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.htmlsanitizer.HtmlSanitizerService;
import org.nuxeo.runtime.api.Framework;

public class HtmlSanitizerListener
implements EventListener {
    public static final String DISABLE_HTMLSANITIZER_LISTENER = "disableHtmlSanitizerListener";

    public void handleEvent(Event event) {
        String eventId = event.getName();
        if (!eventId.equals("aboutToCreate") && !eventId.equals("beforeDocumentModification")) {
            return;
        }
        EventContext context = event.getContext();
        if (!(context instanceof DocumentEventContext)) {
            return;
        }
        Boolean disableListener = (Boolean)context.getProperty(DISABLE_HTMLSANITIZER_LISTENER);
        if (Boolean.TRUE.equals(disableListener)) {
            return;
        }
        DocumentModel doc = ((DocumentEventContext)context).getSourceDocument();
        if (doc.hasFacet("Immutable")) {
            return;
        }
        HtmlSanitizerService sanitizer = (HtmlSanitizerService)Framework.getService(HtmlSanitizerService.class);
        sanitizer.sanitizeDocument(doc);
    }
}

