/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

public class CheckedInDocumentListener
implements EventListener {
    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            CoreSession session = docCtx.getCoreSession();
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc == null) {
                return;
            }
            String docId = doc.getId();
            TagService tagService = (TagService)Framework.getService(TagService.class);
            if (doc instanceof DeletedDocumentModel) {
                tagService.removeTags(session, docId);
                return;
            }
            DocumentRef versionRef = (DocumentRef)ctx.getProperty("checkedInVersionRef");
            if (!tagService.hasFeature(TagService.Feature.TAGS_BELONG_TO_DOCUMENT) && versionRef instanceof IdRef) {
                tagService.copyTags(session, docId, versionRef.toString());
            }
        }
    }
}

