/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryRegistry;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.localconfiguration.DirectoryConfiguration;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DirectoryServiceImpl
extends DefaultComponent
implements DirectoryService {
    protected static final String DELIMITER_BETWEEN_DIRECTORY_NAME_AND_SUFFIX = "_";
    private static final Log log = LogFactory.getLog(DirectoryServiceImpl.class);
    protected DirectoryRegistry registry = new DirectoryRegistry();

    public void activate(ComponentContext context) {
    }

    public void deactivate(ComponentContext context) {
        this.registry.shutdown();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        DirectoryFactoryDescriptor factoryDescriptor = (DirectoryFactoryDescriptor)contribution;
        String factoryName = factoryDescriptor.getFactoryName();
        log.warn((Object)("No need to register factoryDescriptor anymore: " + factoryName));
    }

    public void registerDirectoryDescriptor(BaseDirectoryDescriptor descriptor) {
        this.registry.addContribution(descriptor);
    }

    public void unregisterDirectoryDescriptor(BaseDirectoryDescriptor descriptor) {
        this.registry.removeContribution(descriptor);
    }

    public int getApplicationStartedOrder() {
        return 97;
    }

    public void start(ComponentContext context) {
        List<Directory> directories = this.getDirectories();
        directories.forEach(Directory::initialize);
        directories.forEach(Directory::initializeReferences);
        directories.forEach(Directory::initializeInverseReferences);
    }

    protected DirectoryConfiguration getDirectoryConfiguration(DocumentModel documentContext) {
        LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
        if (localConfigurationService == null) {
            log.info((Object)"Local configuration not deployed, will use default configuration");
            return null;
        }
        return (DirectoryConfiguration)localConfigurationService.getConfiguration(DirectoryConfiguration.class, "DirectoryLocalConfiguration", documentContext);
    }

    protected String getWaitingLocalDirectoryName(String directoryName, DirectoryConfiguration configuration) {
        if (directoryName == null) {
            return null;
        }
        if (configuration != null && configuration.getDirectorySuffix() != null) {
            String suffix = configuration.getDirectorySuffix().trim();
            if (!"".equals(suffix)) {
                return directoryName + DELIMITER_BETWEEN_DIRECTORY_NAME_AND_SUFFIX + suffix;
            }
            log.warn((Object)"The local configuration detected is an empty value, we consider it as no configuration set.");
            log.debug((Object)("Directory Local Configuration is on : " + configuration.getDocumentRef()));
        }
        return directoryName;
    }

    public BaseDirectoryDescriptor getDirectoryDescriptor(String id) {
        return this.registry.getDirectoryDescriptor(id);
    }

    public Directory getDirectory(String id) {
        if (id == null) {
            return null;
        }
        return this.registry.getDirectory(id);
    }

    public Directory getDirectory(String id, DocumentModel documentContext) {
        if (id == null) {
            return null;
        }
        String localDirectoryName = this.getWaitingLocalDirectoryName(id, this.getDirectoryConfiguration(documentContext));
        Directory dir = this.getDirectory(localDirectoryName);
        if (dir == null && !id.equals(localDirectoryName)) {
            log.debug((Object)String.format("The local directory named '%s' was not found. Look for the default one named: %s", localDirectoryName, id));
            dir = this.getDirectory(id);
        }
        return dir;
    }

    protected Directory getDirectoryOrFail(String name) {
        return this.getDirectoryOrFail(name, null);
    }

    protected Directory getDirectoryOrFail(String id, DocumentModel documentContext) {
        Directory dir = this.getDirectory(id, documentContext);
        if (dir == null) {
            throw new DirectoryException("No directory registered with name: " + id);
        }
        return dir;
    }

    public List<Directory> getDirectories() {
        return this.registry.getDirectories();
    }

    public List<String> getDirectoryNames() {
        return this.registry.getDirectoryIds();
    }

    public String getDirectorySchema(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getSchema();
    }

    public String getDirectoryIdField(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getIdField();
    }

    public String getDirectoryPasswordField(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getPasswordField();
    }

    public String getParentDirectoryName(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getParentDirectory();
    }

    public Session open(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getSession();
    }

    public Session open(String directoryName, DocumentModel documentContext) {
        return this.getDirectoryOrFail(directoryName, documentContext).getSession();
    }
}

