/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.localconfiguration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.localconfiguration.AbstractLocalConfiguration;
import org.nuxeo.ecm.directory.localconfiguration.DirectoryConfiguration;

public class DirectoryConfigurationAdapter
extends AbstractLocalConfiguration<DirectoryConfiguration>
implements DirectoryConfiguration {
    private static final Log log = LogFactory.getLog(DirectoryConfigurationAdapter.class);
    protected DocumentRef documentRef;
    protected String lcDirectorySuffix;

    public DirectoryConfigurationAdapter(DocumentModel doc) {
        this.documentRef = doc.getRef();
        try {
            this.lcDirectorySuffix = (String)((Object)doc.getPropertyValue("dirconf:suffix"));
            if (this.lcDirectorySuffix != null) {
                this.lcDirectorySuffix = this.lcDirectorySuffix.trim();
            }
        }
        catch (PropertyException e) {
            log.error((Object)"Failed to get DirectoryConfiguration", (Throwable)e);
        }
    }

    public boolean canMerge() {
        return false;
    }

    public DocumentRef getDocumentRef() {
        return this.documentRef;
    }

    public DirectoryConfiguration merge(DirectoryConfiguration other) {
        throw new UnsupportedOperationException("Directory configurations can't be merged");
    }

    public String getDirectorySuffix() {
        return this.lcDirectorySuffix;
    }
}

