/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.memory.MemoryDirectory;
import org.nuxeo.ecm.directory.memory.MemoryDirectoryExpressionEvaluator;

public class MemoryDirectorySession
extends BaseSession {
    protected final Map<String, Map<String, Object>> data;
    protected final String passwordField;
    protected NuxeoException closeStackTrace;

    public MemoryDirectorySession(MemoryDirectory directory) {
        super((Directory)directory, null);
        this.data = directory.data;
        this.passwordField = this.getPasswordField();
    }

    public MemoryDirectory getDirectory() {
        return (MemoryDirectory)this.directory;
    }

    public boolean authenticate(String username, String password) {
        this.checkClose();
        Map<String, Object> map = this.data.get(username);
        if (map == null) {
            return false;
        }
        String expected = (String)map.get(this.passwordField);
        if (expected == null) {
            return false;
        }
        return expected.equals(password);
    }

    public void close() {
        NuxeoException exc = new NuxeoException("debug close stack trace");
        if (this.closeStackTrace == null) {
            this.closeStackTrace = exc;
        } else {
            this.closeStackTrace.addSuppressed((Throwable)exc);
        }
        this.getDirectory().removeSession((Session)this);
    }

    protected void checkClose() {
        if (this.closeStackTrace != null) {
            NuxeoException exc = new NuxeoException("Session is closed");
            exc.addSuppressed((Throwable)this.closeStackTrace);
            throw exc;
        }
    }

    public void commit() {
    }

    public void rollback() {
        throw new RuntimeException("Not implemented");
    }

    public DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) {
        this.checkClose();
        Object rawId = fieldMap.get(this.getIdField());
        if (rawId == null) {
            throw new DirectoryException("Missing id");
        }
        String id = String.valueOf(rawId);
        Map<String, Object> map = this.data.get(id);
        if (map != null) {
            throw new DirectoryException(String.format("Entry with id %s already exists in directory %s", id, this.directory.getName()));
        }
        map = new HashMap<String, Object>();
        this.data.put(id, map);
        for (Map.Entry<String, Object> e : fieldMap.entrySet()) {
            String fieldName = e.getKey();
            if (!this.getDirectory().schemaSet.contains(fieldName)) continue;
            map.put(fieldName, e.getValue());
        }
        return this.getEntry(id);
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) {
        this.checkClose();
        String id = docModel.getId();
        DataModel dataModel = docModel.getDataModel(this.directory.getSchema());
        Map<String, Object> map = this.data.get(id);
        if (map == null) {
            throw new DirectoryException("UpdateEntry failed: entry '" + id + "' not found");
        }
        for (String fieldName : this.getDirectory().schemaSet) {
            try {
                if (!dataModel.isDirty(fieldName)) continue;
                if (fieldName.equals(this.getIdField())) {
                }
            }
            catch (PropertyNotFoundException e) {}
            continue;
            map.put(fieldName, dataModel.getData(fieldName));
        }
        dataModel.getDirtyFields().clear();
        return new ArrayList<String>();
    }

    protected void deleteEntryWithoutReferences(String id) {
        this.checkClose();
        this.checkDeleteConstraints(id);
        this.data.remove(id);
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) {
        this.checkClose();
        this.checkPermission("Write");
        return this.createEntryWithoutReferences(fieldMap);
    }

    public void updateEntry(DocumentModel docModel) {
        this.checkClose();
        this.checkPermission("Write");
        this.updateEntryWithoutReferences(docModel);
    }

    public void deleteEntry(String id) {
        this.checkClose();
        this.checkPermission("Write");
        this.deleteEntryWithoutReferences(id);
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) {
        this.checkClose();
        Map<String, Object> map = this.data.get(id);
        if (map == null) {
            return null;
        }
        if (this.passwordField != null && map.get(this.passwordField) != null) {
            map = new HashMap<String, Object>(map);
            map.remove(this.passwordField);
        }
        try {
            return MemoryDirectorySession.createEntryModel(null, (String)this.directory.getSchema(), (String)id, map, (boolean)this.isReadOnly());
        }
        catch (PropertyException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public DocumentModelList getEntries() {
        this.checkClose();
        DocumentModelListImpl list = new DocumentModelListImpl();
        for (String id : this.data.keySet()) {
            list.add((Object)this.getEntry(id));
        }
        return list;
    }

    public void deleteEntry(String id, Map<String, String> map) {
        this.checkClose();
        throw new DirectoryException("Not implemented");
    }

    public void deleteEntry(DocumentModel docModel) {
        this.checkClose();
        this.deleteEntry(docModel.getId());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) {
        this.checkClose();
        DocumentModelListImpl results = new DocumentModelListImpl();
        HashMap<String, Serializable> filt = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> entry : filter.entrySet()) {
            String fieldName = entry.getKey();
            if (!this.getDirectory().schemaSet.contains(fieldName)) continue;
            filt.put(fieldName, entry.getValue());
        }
        block1: for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            String id = entry.getKey();
            Map map = (Map)entry.getValue();
            for (Map.Entry e : filt.entrySet()) {
                String fieldName = (String)e.getKey();
                Object expected = e.getValue();
                Object value = map.get(fieldName);
                if (!(value == null ? expected != null : (fulltext != null && fulltext.contains(fieldName) ? !value.toString().toLowerCase().startsWith(expected.toString().toLowerCase()) : !value.equals(expected)))) continue;
                continue block1;
            }
            results.add((Object)this.getEntry(id));
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            this.getDirectory().orderEntries((List<DocumentModel>)results, orderBy);
        }
        return this.applyQueryLimits((DocumentModelList)results, limit, offset);
    }

    public DocumentModelList query(QueryBuilder queryBuilder, boolean fetchReferences) {
        this.checkClose();
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.passwordField)) {
            throw new DirectoryException("Cannot filter on password");
        }
        DocumentModelListImpl results = new DocumentModelListImpl();
        MultiExpression expression = queryBuilder.predicate();
        OrderByList orders = queryBuilder.orders();
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        boolean countTotal = queryBuilder.countTotal();
        MemoryDirectoryExpressionEvaluator evaluator = new MemoryDirectoryExpressionEvaluator(this.getDirectory());
        for (Map.Entry<String, Map<String, Object>> datae : this.data.entrySet()) {
            if (!evaluator.matchesEntry((Expression)expression, datae.getValue())) continue;
            results.add((Object)this.getEntry(datae.getKey()));
        }
        if (!orders.isEmpty()) {
            this.getDirectory().orderEntries((List<DocumentModel>)results, AbstractDirectory.makeOrderBy(orders));
        }
        results = this.applyQueryLimits((DocumentModelList)results, limit, offset);
        if (!(limit == 0 && offset == 0 || countTotal)) {
            results.setTotalSize(-2L);
        }
        return results;
    }

    public List<String> queryIds(QueryBuilder queryBuilder) {
        this.checkClose();
        if (!this.hasPermission("Read")) {
            return Collections.emptyList();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.passwordField)) {
            throw new DirectoryException("Cannot filter on password");
        }
        DocumentModelListImpl entries = new DocumentModelListImpl();
        ArrayList<String> ids = new ArrayList<String>();
        MultiExpression expression = queryBuilder.predicate();
        OrderByList orders = queryBuilder.orders();
        boolean order = !orders.isEmpty();
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        MemoryDirectoryExpressionEvaluator evaluator = new MemoryDirectoryExpressionEvaluator(this.getDirectory());
        for (Map.Entry<String, Map<String, Object>> datae : this.data.entrySet()) {
            if (!evaluator.matchesEntry((Expression)expression, datae.getValue())) continue;
            String id = datae.getKey();
            if (order) {
                entries.add((Object)this.getEntry(id));
                continue;
            }
            ids.add(id);
        }
        if (order) {
            this.getDirectory().orderEntries((List<DocumentModel>)entries, AbstractDirectory.makeOrderBy(orders));
            entries.forEach(doc -> ids.add(doc.getId()));
        }
        return this.applyQueryLimits(ids, limit, offset);
    }

    public DocumentModel createEntry(DocumentModel entry) {
        this.checkClose();
        Map fieldMap = entry.getProperties(this.directory.getSchema());
        return this.createEntry(fieldMap);
    }

    public boolean hasEntry(String id) {
        this.checkClose();
        return this.data.containsKey(id);
    }
}

