/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.nuxeo.ecm.core.CoreServiceOrphanVersionRemovalFilterDescriptor;
import org.nuxeo.ecm.core.CoreServicePolicyDescriptor;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.versioning.DefaultVersionRemovalPolicy;
import org.nuxeo.ecm.core.versioning.OrphanVersionRemovalFilter;
import org.nuxeo.ecm.core.versioning.VersionRemovalPolicy;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class CoreService
extends DefaultComponent {
    private static final String VERSION_REMOVAL_POLICY_XP = "versionRemovalPolicy";
    private static final String ORPHAN_VERSION_REMOVAL_FILTER_XP = "orphanVersionRemovalFilter";
    protected static final DefaultVersionRemovalPolicy DEFAULT_VERSION_REMOVAL_POLICY = new DefaultVersionRemovalPolicy();
    protected Map<CoreServicePolicyDescriptor, VersionRemovalPolicy> versionRemovalPolicies = new LinkedHashMap<CoreServicePolicyDescriptor, VersionRemovalPolicy>();
    protected Map<CoreServiceOrphanVersionRemovalFilterDescriptor, OrphanVersionRemovalFilter> orphanVersionRemovalFilters = new LinkedHashMap<CoreServiceOrphanVersionRemovalFilterDescriptor, OrphanVersionRemovalFilter>();
    protected ComponentContext context;

    public void activate(ComponentContext context) {
        this.context = context;
    }

    public void deactivate(ComponentContext context) {
        this.context = null;
    }

    public void registerContribution(Object contrib, String point, ComponentInstance contributor) {
        if (VERSION_REMOVAL_POLICY_XP.equals(point)) {
            this.registerVersionRemovalPolicy((CoreServicePolicyDescriptor)contrib);
        } else if (ORPHAN_VERSION_REMOVAL_FILTER_XP.equals(point)) {
            this.registerOrphanVersionRemovalFilter((CoreServiceOrphanVersionRemovalFilterDescriptor)contrib);
        } else {
            throw new RuntimeException("Unknown extension point: " + point);
        }
    }

    public void unregisterContribution(Object contrib, String point, ComponentInstance contributor) {
        if (VERSION_REMOVAL_POLICY_XP.equals(point)) {
            this.unregisterVersionRemovalPolicy((CoreServicePolicyDescriptor)contrib);
        } else if (ORPHAN_VERSION_REMOVAL_FILTER_XP.equals(point)) {
            this.unregisterOrphanVersionRemovalFilter((CoreServiceOrphanVersionRemovalFilterDescriptor)contrib);
        }
    }

    protected void registerVersionRemovalPolicy(CoreServicePolicyDescriptor contrib) {
        String klass = contrib.getKlass();
        try {
            VersionRemovalPolicy policy = (VersionRemovalPolicy)this.context.getRuntimeContext().loadClass(klass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.versionRemovalPolicies.put(contrib, policy);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate versionRemovalPolicy: " + klass, e);
        }
    }

    protected void unregisterVersionRemovalPolicy(CoreServicePolicyDescriptor contrib) {
        this.versionRemovalPolicies.remove(contrib);
    }

    protected void registerOrphanVersionRemovalFilter(CoreServiceOrphanVersionRemovalFilterDescriptor contrib) {
        String klass = contrib.getKlass();
        try {
            OrphanVersionRemovalFilter filter = (OrphanVersionRemovalFilter)this.context.getRuntimeContext().loadClass(klass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.orphanVersionRemovalFilters.put(contrib, filter);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate orphanVersionRemovalFilter: " + klass, e);
        }
    }

    protected void unregisterOrphanVersionRemovalFilter(CoreServiceOrphanVersionRemovalFilterDescriptor contrib) {
        this.orphanVersionRemovalFilters.remove(contrib);
    }

    public VersionRemovalPolicy getVersionRemovalPolicy() {
        if (this.versionRemovalPolicies.isEmpty()) {
            return DEFAULT_VERSION_REMOVAL_POLICY;
        }
        VersionRemovalPolicy versionRemovalPolicy = null;
        Iterator<VersionRemovalPolicy> iterator = this.versionRemovalPolicies.values().iterator();
        while (iterator.hasNext()) {
            VersionRemovalPolicy policy;
            versionRemovalPolicy = policy = iterator.next();
        }
        return versionRemovalPolicy;
    }

    public Collection<OrphanVersionRemovalFilter> getOrphanVersionRemovalFilters() {
        return this.orphanVersionRemovalFilters.values();
    }

    public long cleanupOrphanVersions(long commitSize) {
        RepositoryService repositoryService = (RepositoryService)((Object)Framework.getService(RepositoryService.class));
        if (repositoryService == null) {
            return 0L;
        }
        List<String> repositoryNames = repositoryService.getRepositoryNames();
        AtomicLong count = new AtomicLong();
        for (String repositoryName : repositoryNames) {
            TransactionHelper.runInTransaction(() -> CoreInstance.doPrivileged((String)repositoryName, session -> count.addAndGet(this.doCleanupOrphanVersions((CoreSession)session, commitSize))));
        }
        return count.get();
    }

    protected long doCleanupOrphanVersions(CoreSession session, long commitSize) {
        HashMap<String, List> versionSeriesToVersionIds = new HashMap<String, List>();
        String findVersions = "SELECT ecm:uuid, ecm:versionVersionableId FROM Document WHERE ecm:isVersion = 1";
        try (IterableQueryResult res = session.queryAndFetch(findVersions, "NXQL", new Object[0]);){
            for (Map map : res) {
                String versionSeriesId = (String)map.get("ecm:versionVersionableId");
                String versionId = (String)map.get("ecm:uuid");
                versionSeriesToVersionIds.computeIfAbsent(versionSeriesId, k -> new ArrayList(4)).add(versionId);
            }
        }
        HashSet<String> seriesIds = new HashSet<String>();
        String findLive = "SELECT ecm:uuid FROM Document WHERE ecm:isProxy = 0 AND ecm:isVersion = 0";
        try (IterableQueryResult res = session.queryAndFetch(findLive, "NXQL", new Object[0]);){
            for (Iterator map : res) {
                String id = (String)map.get("ecm:uuid");
                seriesIds.add(id);
            }
        }
        String findProxies = "SELECT ecm:proxyVersionableId FROM Document WHERE ecm:isProxy = 1";
        try (IterableQueryResult res = session.queryAndFetch(findProxies, "NXQL", new Object[0]);){
            for (Map map : res) {
                String versionSeriesId = (String)map.get("ecm:proxyVersionableId");
                seriesIds.add(versionSeriesId);
            }
        }
        HashSet ids = new HashSet();
        for (Map.Entry en : versionSeriesToVersionIds.entrySet()) {
            if (seriesIds.contains(en.getKey())) continue;
            List versionIds = (List)en.getValue();
            ids.addAll(versionIds);
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        if (!ids.isEmpty()) {
            long n = 0L;
            for (String id : ids) {
                session.removeDocument((DocumentRef)new IdRef(id));
                if (++n < commitSize) continue;
                session.save();
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
                n = 0L;
            }
            session.save();
        }
        return ids.size();
    }
}

