/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.BlobDispatcher;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.runtime.api.Framework;

public class DefaultBlobDispatcher
implements BlobDispatcher {
    private static final Log log = LogFactory.getLog(DefaultBlobDispatcher.class);
    protected static final String NAME_DEFAULT = "default";
    protected static final Pattern NAME_PATTERN = Pattern.compile("(.*)(=|!=|<|>|~)(.*)");
    protected static final String REPOSITORY_NAME = "ecm:repositoryName";
    protected static final String BLOB_PREFIX = "blob:";
    protected static final String BLOB_NAME = "name";
    protected static final String BLOB_MIME_TYPE = "mime-type";
    protected static final String BLOB_ENCODING = "encoding";
    protected static final String BLOB_DIGEST = "digest";
    protected static final String BLOB_LENGTH = "length";
    protected static final String BLOB_XPATH = "xpath";
    protected boolean useRepositoryName = true;
    protected List<Rule> rules;
    protected Set<String> rulesXPaths;
    protected Set<String> providerIds;
    protected List<String> repositoryNames;
    protected String defaultProviderId;

    @Override
    public void initialize(Map<String, String> properties) {
        this.providerIds = new HashSet<String>();
        this.rulesXPaths = new HashSet<String>();
        this.rules = new ArrayList<Rule>();
        for (Map.Entry<String, String> en : properties.entrySet()) {
            String clausesString = en.getKey();
            String providerId = en.getValue();
            this.providerIds.add(providerId);
            if (clausesString.equals(NAME_DEFAULT)) {
                this.defaultProviderId = providerId;
                continue;
            }
            ArrayList<Clause> clauses = new ArrayList<Clause>(2);
            block15: for (String name : clausesString.split(",")) {
                Matcher m = NAME_PATTERN.matcher(name);
                if (m.matches()) {
                    Op op;
                    String xpath = m.group(1);
                    String ops = m.group(2);
                    Object value = m.group(3);
                    switch (ops) {
                        case "=": {
                            op = Op.EQ;
                            break;
                        }
                        case "!=": {
                            op = Op.NEQ;
                            break;
                        }
                        case "<": {
                            op = Op.LT;
                            value = Long.valueOf((String)value);
                            break;
                        }
                        case ">": {
                            op = Op.GT;
                            value = Long.valueOf((String)value);
                            break;
                        }
                        case "~": {
                            op = Op.GLOB;
                            value = this.getPatternFromGlob((String)value);
                            break;
                        }
                        default: {
                            log.error((Object)("Invalid dispatcher configuration operator: " + ops));
                            continue block15;
                        }
                    }
                    clauses.add(new Clause(xpath, op, value));
                    this.rulesXPaths.add(xpath);
                } else {
                    log.error((Object)("Invalid dispatcher configuration property name: " + name));
                }
                this.rules.add(new Rule(clauses, providerId));
            }
        }
        this.useRepositoryName = this.providerIds.isEmpty();
        if (!this.useRepositoryName && this.defaultProviderId == null) {
            log.error((Object)"Invalid dispatcher configuration, missing default, configuration will be ignored");
            this.useRepositoryName = true;
        }
    }

    protected Pattern getPatternFromGlob(String glob) {
        String regex = Pattern.quote(glob).replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q");
        return Pattern.compile(regex);
    }

    @Override
    public Collection<String> getBlobProviderIds() {
        if (this.useRepositoryName) {
            if (this.repositoryNames == null) {
                this.repositoryNames = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepositoryNames();
            }
            return this.repositoryNames;
        }
        return this.providerIds;
    }

    protected String getProviderId(Document doc, Blob blob, String blobXPath) {
        if (this.useRepositoryName) {
            return doc.getRepositoryName();
        }
        for (Rule rule : this.rules) {
            boolean allClausesMatch = true;
            for (Clause clause : rule.clauses) {
                boolean match;
                Object value;
                block33: {
                    String xpath;
                    block34: {
                        block32: {
                            xpath = clause.xpath;
                            if (!xpath.equals(REPOSITORY_NAME)) break block32;
                            value = doc.getRepositoryName();
                            break block33;
                        }
                        if (!xpath.startsWith(BLOB_PREFIX)) break block34;
                        switch (xpath.substring(BLOB_PREFIX.length())) {
                            case "name": {
                                value = blob.getFilename();
                                break block33;
                            }
                            case "mime-type": {
                                value = blob.getMimeType();
                                break block33;
                            }
                            case "encoding": {
                                value = blob.getEncoding();
                                break block33;
                            }
                            case "digest": {
                                value = blob.getDigest();
                                break block33;
                            }
                            case "length": {
                                value = blob.getLength();
                                break block33;
                            }
                            case "xpath": {
                                value = blobXPath;
                                break block33;
                            }
                            default: {
                                log.error((Object)("Invalid dispatcher configuration property name: " + xpath));
                                break;
                            }
                        }
                        continue;
                    }
                    try {
                        value = doc.getValue(xpath);
                    }
                    catch (PropertyNotFoundException e) {
                        try {
                            value = doc.getPropertyValue(xpath);
                        }
                        catch (PropertyNotFoundException e2) {
                            allClausesMatch = false;
                            break;
                        }
                    }
                }
                switch (clause.op) {
                    case EQ: {
                        match = String.valueOf(value).equals(clause.value);
                        break;
                    }
                    case NEQ: {
                        match = !String.valueOf(value).equals(clause.value);
                        break;
                    }
                    case LT: {
                        if (value == null) {
                            value = 0L;
                        }
                        match = ((Long)value).compareTo((Long)clause.value) < 0;
                        break;
                    }
                    case GT: {
                        if (value == null) {
                            value = 0L;
                        }
                        match = ((Long)value).compareTo((Long)clause.value) > 0;
                        break;
                    }
                    case GLOB: {
                        match = ((Pattern)clause.value).matcher(String.valueOf(value)).matches();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"notreached");
                    }
                }
                if (allClausesMatch = allClausesMatch && match) continue;
                break;
            }
            if (!allClausesMatch) continue;
            return rule.providerId;
        }
        return this.defaultProviderId;
    }

    @Override
    public String getBlobProvider(String repositoryName) {
        if (this.useRepositoryName) {
            return repositoryName;
        }
        return this.defaultProviderId;
    }

    @Override
    public BlobDispatcher.BlobDispatch getBlobProvider(Document doc, Blob blob, String xpath) {
        if (this.useRepositoryName) {
            String providerId = doc.getRepositoryName();
            return new BlobDispatcher.BlobDispatch(providerId, false);
        }
        String providerId = this.getProviderId(doc, blob, xpath);
        return new BlobDispatcher.BlobDispatch(providerId, true);
    }

    @Override
    public void notifyChanges(Document doc, Set<String> xpaths) {
        if (this.useRepositoryName) {
            return;
        }
        for (String xpath : this.rulesXPaths) {
            if (!xpaths.contains(xpath)) continue;
            doc.visitBlobs(accessor -> this.checkBlob(doc, (Document.BlobAccessor)accessor));
            return;
        }
    }

    protected void checkBlob(Document doc, Document.BlobAccessor accessor) {
        Blob newBlob;
        Blob blob = accessor.getBlob();
        if (!(blob instanceof ManagedBlob)) {
            return;
        }
        String expectedProviderId = this.getProviderId(doc, blob, accessor.getXPath());
        if (((ManagedBlob)blob).getProviderId().equals(expectedProviderId)) {
            return;
        }
        try (InputStream in = blob.getStream();){
            newBlob = Blobs.createBlob((InputStream)in, (String)blob.getMimeType(), (String)blob.getEncoding());
            newBlob.setFilename(blob.getFilename());
            newBlob.setDigest(blob.getDigest());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        accessor.setBlob(newBlob);
    }

    protected static class Rule {
        public final List<Clause> clauses;
        public final String providerId;

        public Rule(List<Clause> clauses, String providerId) {
            this.clauses = clauses;
            this.providerId = providerId;
        }
    }

    protected static class Clause {
        public final String xpath;
        public final Op op;
        public final Object value;

        public Clause(String xpath, Op op, Object value) {
            this.xpath = xpath;
            this.op = op;
            this.value = value;
        }
    }

    protected static enum Op {
        EQ,
        NEQ,
        LT,
        GT,
        GLOB;

    }
}

