/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleState;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleDescriptor;
import org.nuxeo.ecm.core.lifecycle.impl.LifeCycleImpl;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class LifeCycleRegistry
extends ContributionFragmentRegistry<LifeCycleDescriptor> {
    private static final Log log = LogFactory.getLog(LifeCycleRegistry.class);
    protected Map<String, LifeCycle> lifeCycles = new HashMap<String, LifeCycle>();

    public String getContributionId(LifeCycleDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, LifeCycleDescriptor contrib, LifeCycleDescriptor newOrigContrib) {
        log.info((Object)("Registering lifecycle: " + contrib.getName()));
        this.lifeCycles.put(contrib.getName(), this.getLifeCycle(contrib));
    }

    public void contributionRemoved(String id, LifeCycleDescriptor lifeCycleDescriptor) {
        log.info((Object)("Unregistering lifecycle: " + lifeCycleDescriptor.getName()));
        this.lifeCycles.remove(lifeCycleDescriptor.getName());
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public LifeCycleDescriptor clone(LifeCycleDescriptor orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(LifeCycleDescriptor src, LifeCycleDescriptor dst) {
        throw new UnsupportedOperationException();
    }

    public LifeCycle getLifeCycle(String name) {
        return this.lifeCycles.get(name);
    }

    public Collection<LifeCycle> getLifeCycles() {
        return this.lifeCycles.values();
    }

    public LifeCycle getLifeCycle(LifeCycleDescriptor desc) {
        String name = desc.getName();
        String initialStateName = desc.getInitialStateName();
        String defaultInitialStateName = desc.getDefaultInitialStateName();
        if (initialStateName != null) {
            defaultInitialStateName = initialStateName;
            log.warn((Object)String.format("Lifecycle registration of default initial state has changed, change initial=\"%s\" to defaultInitial=\"%s\" in lifecyle '%s' definition", defaultInitialStateName, defaultInitialStateName, name));
        }
        boolean defaultInitialStateFound = false;
        HashSet<String> initialStateNames = new HashSet<String>();
        Collection<LifeCycleState> states = desc.getStates();
        for (LifeCycleState state : states) {
            String stateName = state.getName();
            if (defaultInitialStateName.equals(stateName)) {
                defaultInitialStateFound = true;
                initialStateNames.add(stateName);
            }
            if (!state.isInitial()) continue;
            initialStateNames.add(stateName);
        }
        if (!defaultInitialStateFound) {
            log.error((Object)String.format("Default initial state %s not found on lifecycle %s", defaultInitialStateName, name));
        }
        return new LifeCycleImpl(name, defaultInitialStateName, initialStateNames, states, desc.getTransitions());
    }
}

