/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleTypesDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class LifeCycleTypeRegistry
extends ContributionFragmentRegistry<LifeCycleTypesDescriptor> {
    private static final Log log = LogFactory.getLog(LifeCycleTypeRegistry.class);
    protected Map<String, String> typesMapping = new HashMap<String, String>();
    protected Map<String, List<String>> docTypeToNonRecursiveTransition = new HashMap<String, List<String>>();

    public String getContributionId(LifeCycleTypesDescriptor contrib) {
        return contrib.getDocumentType();
    }

    public void contributionUpdated(String id, LifeCycleTypesDescriptor contrib, LifeCycleTypesDescriptor newOrigContrib) {
        log.info((Object)("Registering lifecycle types mapping: " + contrib.getDocumentType() + "-" + contrib.getLifeCycleName()));
        this.typesMapping.put(contrib.getDocumentType(), contrib.getLifeCycleName());
        String transitionArray = contrib.getNoRecursionForTransitions();
        List<Object> transitions = new ArrayList();
        if (transitionArray != null && !transitionArray.isEmpty()) {
            transitions = Arrays.asList(contrib.getNoRecursionForTransitions().split(","));
        }
        this.docTypeToNonRecursiveTransition.put(contrib.getDocumentType(), transitions);
    }

    public void contributionRemoved(String id, LifeCycleTypesDescriptor origContrib) {
        this.typesMapping.remove(id);
        this.docTypeToNonRecursiveTransition.remove(id);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public LifeCycleTypesDescriptor clone(LifeCycleTypesDescriptor orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(LifeCycleTypesDescriptor src, LifeCycleTypesDescriptor dst) {
        throw new UnsupportedOperationException();
    }

    public String getLifeCycleNameForType(String docType) {
        return this.typesMapping.get(docType);
    }

    public Collection<String> getTypesFor(String lifeCycleName) {
        ArrayList<String> types = new ArrayList<String>();
        for (String typeName : this.typesMapping.keySet()) {
            if (!this.typesMapping.get(typeName).equals(lifeCycleName)) continue;
            types.add(typeName);
        }
        return types;
    }

    public Map<String, String> getTypesMapping() {
        return this.typesMapping;
    }

    public List<String> getNonRecursiveTransitionForDocType(String docTypeName) {
        return this.docTypeToNonRecursiveTransition.get(docTypeName);
    }
}

