/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.migrator;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractRepositoryMigrator
implements MigrationService.Migrator {
    private static final Log log = LogFactory.getLog(AbstractRepositoryMigrator.class);
    protected MigrationService.MigrationContext migrationContext;

    protected String probeRepository(String repositoryName) {
        return (String)TransactionHelper.runInTransaction(() -> (String)CoreInstance.doPrivileged((String)repositoryName, this::probeSession));
    }

    protected void checkShutdownRequested() {
        if (this.migrationContext.isShutdownRequested()) {
            throw new MigrationShutdownException();
        }
    }

    protected void reportProgress(String message, long num, long total) {
        log.debug((Object)(message + ": " + num + "/" + total));
        this.migrationContext.reportProgress(message, num, total);
    }

    protected void reportProgress(String repositoryName, String message, long num, long total) {
        this.reportProgress(String.format("[%s] %s", repositoryName, message), num, total);
    }

    protected void migrateRepository(String repositoryName) {
        TransactionHelper.runInTransaction(() -> CoreInstance.doPrivileged((String)repositoryName, this::migrateSession));
    }

    protected <T> void processBatched(int batchSize, Collection<T> collection, Consumer<T> consumer, String progressMessage) {
        int size = collection.size();
        int i = -1;
        for (T element : collection) {
            consumer.accept(element);
            this.checkShutdownRequested();
            if (++i % batchSize != 0 && i != size - 1) continue;
            this.reportProgress(progressMessage, i + 1, size);
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected abstract String probeSession(CoreSession var1);

    protected abstract void migrateSession(CoreSession var1);

    protected static class MigrationShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

