/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.Arrays;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class LockSecurityPolicy
extends AbstractSecurityPolicy {
    protected static final ThreadLocal<Boolean> IGNORE_POLICY = new ThreadLocal();

    @Override
    public Access checkPermission(Document doc, ACP mergedAcp, NuxeoPrincipal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        if (resolvedPermissions == null || !Arrays.asList(resolvedPermissions).contains("Write")) {
            return access;
        }
        if (LockSecurityPolicy.isIgnorePolicy()) {
            return access;
        }
        String username = principal.getName();
        Lock lock = doc.getLock();
        if (lock != null && !username.equals(lock.getOwner())) {
            access = Access.DENY;
        }
        return access;
    }

    @Override
    public boolean isRestrictingPermission(String permission) {
        assert (permission.equals("Browse"));
        return false;
    }

    @Override
    public boolean isExpressibleInQuery(String repositoryName) {
        return true;
    }

    @Override
    public SQLQuery.Transformer getQueryTransformer(String repositoryName) {
        return SQLQuery.Transformer.IDENTITY;
    }

    public static void setIgnorePolicy(boolean ignore) {
        if (ignore) {
            IGNORE_POLICY.set(Boolean.TRUE);
        } else {
            IGNORE_POLICY.remove();
        }
    }

    public static boolean isIgnorePolicy() {
        Boolean ignore = IGNORE_POLICY.get();
        if (ignore == null) {
            IGNORE_POLICY.remove();
        }
        return Boolean.TRUE.equals(ignore);
    }
}

