/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.migrator.AbstractRepositoryMigrator;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.trash.TrashServiceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TrashedStateMigrator
extends AbstractRepositoryMigrator {
    protected static final String QUERY_DELETED = "SELECT ecm:uuid FROM Document WHERE ecm:currentLifeCycleState = 'deleted' AND ecm:isVersion = 0";
    protected static final int BATCH_SIZE = 50;

    public void notifyStatusChange() {
        TrashServiceImpl trashService = (TrashServiceImpl)((Object)Framework.getService(TrashServiceImpl.class));
        trashService.invalidateTrashServiceImplementation();
    }

    public String probeState() {
        List<String> repositoryNames = ((RepositoryService)((Object)Framework.getService(RepositoryService.class))).getRepositoryNames();
        if (repositoryNames.stream().map(this::probeRepository).anyMatch(Predicate.isEqual("lifecycle"))) {
            return "lifecycle";
        }
        return "property";
    }

    @Override
    protected String probeSession(CoreSession session) {
        PartialList deletedMaps = session.queryProjection(QUERY_DELETED, 1L, 0L);
        if (!deletedMaps.isEmpty()) {
            return "lifecycle";
        }
        return "property";
    }

    public void run(String step, MigrationService.MigrationContext migrationContext) {
        if (!"lifecycle-to-property".equals(step)) {
            throw new NuxeoException("Unknown migration step: " + step);
        }
        this.migrationContext = migrationContext;
        this.reportProgress("Initializing", 0L, -1L);
        List<String> repositoryNames = ((RepositoryService)((Object)Framework.getService(RepositoryService.class))).getRepositoryNames();
        try {
            repositoryNames.forEach(this::migrateRepository);
            this.reportProgress("Done", 1L, 1L);
        }
        catch (AbstractRepositoryMigrator.MigrationShutdownException e) {
            return;
        }
    }

    @Override
    protected void migrateRepository(String repositoryName) {
        this.reportProgress(repositoryName, "Initializing", 0L, -1L);
        super.migrateRepository(repositoryName);
    }

    @Override
    protected void migrateSession(CoreSession session) {
        PartialList deletedMaps = session.queryProjection(QUERY_DELETED, -1L, 0L);
        this.checkShutdownRequested();
        List ids = deletedMaps.stream().map(map -> (String)map.get("ecm:uuid")).collect(Collectors.toList());
        this.checkShutdownRequested();
        int size = ids.size();
        int i = 0;
        this.reportProgress(session.getRepositoryName(), "Setting isTrashed property", i, size);
        LifeCycleService lifeCycleService = (LifeCycleService)Framework.getService(LifeCycleService.class);
        for (String id : ids) {
            Document doc = ((AbstractSession)session).getSession().getDocumentByUUID(id);
            doc.setSystemProp("isTrashed", (Serializable)Boolean.TRUE);
            try {
                lifeCycleService.followTransition(doc, "undelete");
            }
            catch (LifeCycleException e) {
                doc.setCurrentLifeCycleState("project");
            }
            this.checkShutdownRequested();
            if (++i % 50 != 0 && i != size) continue;
            this.reportProgress(session.getRepositoryName(), "Setting isTrashed property", i, size);
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        this.reportProgress(session.getRepositoryName(), "Done", size, size);
    }
}

