/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.versioning.DefaultVersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.ExtendableVersioningService;
import org.nuxeo.ecm.core.versioning.InitialStateDescriptor;
import org.nuxeo.ecm.core.versioning.SaveOptionsDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningFilterDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningPolicyDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRestrictionDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRestrictionOptionsDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRuleDescriptor;
import org.nuxeo.runtime.api.Framework;

public class StandardVersioningService
implements ExtendableVersioningService {
    private static final Logger log = LogManager.getLogger(StandardVersioningService.class);
    protected static final int DEFAULT_FORMER_RULE_ORDER = 10000;
    protected static final String COMPAT_ID_PREFIX = "compatibility-type-";
    protected static final String COMPAT_DEFAULT_ID = "compatibility-default";
    @Deprecated
    public static final String FILE_TYPE = "File";
    @Deprecated
    public static final String NOTE_TYPE = "Note";
    @Deprecated
    public static final String PROJECT_STATE = "project";
    public static final String APPROVED_STATE = "approved";
    public static final String OBSOLETE_STATE = "obsolete";
    public static final String BACK_TO_PROJECT_TRANSITION = "backToProject";
    @Deprecated
    protected static final String AUTO_CHECKED_OUT = "AUTO_CHECKED_OUT";
    protected static final String MAJOR_VERSION = "ecm:majorVersion";
    protected static final String MINOR_VERSION = "ecm:minorVersion";
    public static final String CATEGORY = "category";
    public static final String COMMENT = "comment";
    private Map<String, VersioningPolicyDescriptor> versioningPolicies = new HashMap<String, VersioningPolicyDescriptor>();
    private Map<String, VersioningFilterDescriptor> versioningFilters = new HashMap<String, VersioningFilterDescriptor>();
    private Map<String, VersioningRestrictionDescriptor> versioningRestrictions = new HashMap<String, VersioningRestrictionDescriptor>();

    public String getVersionLabel(DocumentModel docModel) {
        Object label;
        try {
            label = this.getMajor(docModel) + "." + this.getMinor(docModel);
            if (docModel.isCheckedOut() && !"0.0".equals(label)) {
                label = (String)label + "+";
            }
        }
        catch (PropertyNotFoundException e) {
            label = "";
        }
        return label;
    }

    protected long getMajor(DocumentModel docModel) {
        return this.getVersion(docModel, "uid:major_version");
    }

    protected long getMinor(DocumentModel docModel) {
        return this.getVersion(docModel, "uid:minor_version");
    }

    protected long getVersion(DocumentModel docModel, String prop) {
        Serializable propVal = docModel.getPropertyValue(prop);
        if (propVal instanceof Long) {
            return (Long)propVal;
        }
        return 0L;
    }

    protected long getMajor(Document doc) {
        return this.getVersion(doc, MAJOR_VERSION);
    }

    protected long getMinor(Document doc) {
        return this.getVersion(doc, MINOR_VERSION);
    }

    protected long getVersion(Document doc, String prop) {
        Serializable propVal = doc.getPropertyValue(prop);
        if (propVal instanceof Long) {
            return (Long)propVal;
        }
        return 0L;
    }

    protected void setVersion(Document doc, long major, long minor) {
        doc.setPropertyValue(MAJOR_VERSION, (Serializable)Long.valueOf(major));
        doc.setPropertyValue(MINOR_VERSION, (Serializable)Long.valueOf(minor));
    }

    protected void incrementMajor(Document doc) {
        this.setVersion(doc, this.getMajor(doc) + 1L, 0L);
    }

    protected void incrementMinor(Document doc) {
        this.setVersion(doc, this.getMajor(doc), this.getMinor(doc) + 1L);
    }

    protected void incrementByOption(Document doc, VersioningOption option) {
        try {
            if (option == VersioningOption.MAJOR) {
                this.incrementMajor(doc);
            } else if (option == VersioningOption.MINOR) {
                this.incrementMinor(doc);
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
    }

    public void doPostCreate(Document doc, Map<String, Serializable> options) {
        if (doc.isVersion() || doc.isProxy()) {
            return;
        }
        this.setInitialVersion(doc);
    }

    protected void setInitialVersion(Document doc) {
        DocumentModelImpl docModel = DocumentModelFactory.createDocumentModel(doc, null, null);
        InitialStateDescriptor initialState = this.versioningPolicies.values().stream().sorted().filter(policy -> policy.getInitialState() != null).filter(arg_0 -> this.lambda$setInitialVersion$1((DocumentModel)docModel, arg_0)).map(VersioningPolicyDescriptor::getInitialState).findFirst().orElseGet(InitialStateDescriptor::new);
        this.setVersion(doc, initialState.getMajor(), initialState.getMinor());
    }

    public List<VersioningOption> getSaveOptions(DocumentModel docModel) {
        boolean versionable = docModel.isVersionable();
        String lifeCycleState = docModel.getCoreSession().getCurrentLifeCycleState(docModel.getRef());
        String type = docModel.getType();
        return this.getSaveOptions(versionable, lifeCycleState, type);
    }

    protected List<VersioningOption> getSaveOptions(Document doc) {
        String lifeCycleState;
        boolean versionable = doc.getType().getFacets().contains("Versionable");
        try {
            lifeCycleState = doc.getLifeCycleState();
        }
        catch (LifeCycleException e) {
            lifeCycleState = null;
        }
        String type = doc.getType().getName();
        return this.getSaveOptions(versionable, lifeCycleState, type);
    }

    protected List<VersioningOption> getSaveOptions(boolean versionable, String lifeCycleState, String type) {
        if (!versionable) {
            return Collections.singletonList(VersioningOption.NONE);
        }
        List<VersioningOption> options = this.computeRestrictionOptions(lifeCycleState, type);
        if (options == null) {
            options = this.computeRestrictionOptions(lifeCycleState, "*");
        }
        if (options != null) {
            return options;
        }
        return Arrays.asList(VersioningOption.values());
    }

    protected List<VersioningOption> computeRestrictionOptions(String lifeCycleState, String type) {
        VersioningRestrictionDescriptor restrictions = this.versioningRestrictions.get(type);
        if (restrictions != null) {
            VersioningRestrictionOptionsDescriptor restrictionOptions = null;
            if (lifeCycleState != null) {
                restrictionOptions = restrictions.getRestrictionOption(lifeCycleState);
            }
            if (restrictionOptions == null) {
                restrictionOptions = restrictions.getRestrictionOption("*");
            }
            if (restrictionOptions != null) {
                return restrictionOptions.getOptions();
            }
        }
        return null;
    }

    protected VersioningOption validateOption(Document doc, VersioningOption option) {
        String lifeCycleState;
        List<VersioningOption> options = this.getSaveOptions(doc);
        String type = doc.getType().getName();
        try {
            lifeCycleState = doc.getLifeCycleState();
        }
        catch (LifeCycleException e) {
            lifeCycleState = null;
        }
        if (option == null) {
            if (options.isEmpty() || options.contains(VersioningOption.NONE)) {
                return VersioningOption.NONE;
            }
            throw new NuxeoException("Versioning configuration restricts documents with type=" + type + "/lifeCycleState=" + lifeCycleState + " must be versioned for each updates.");
        }
        if (!options.contains(option)) {
            throw new NuxeoException("Versioning option=" + option + " is not allowed by the configuration for type=" + type + "/lifeCycleState=" + lifeCycleState);
        }
        return option;
    }

    public boolean isPreSaveDoingCheckOut(Document doc, boolean isDirty, VersioningOption option, Map<String, Serializable> options) {
        boolean disableAutoCheckOut = Boolean.TRUE.equals(options.get("DisableAutoCheckOut"));
        return !doc.isCheckedOut() && isDirty && !disableAutoCheckOut;
    }

    public VersioningOption doPreSave(CoreSession session, Document doc, boolean isDirty, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        if (this.isPreSaveDoingCheckOut(doc, isDirty, option = this.validateOption(doc, option), options)) {
            this.doCheckOut(doc);
            this.followTransitionByOption(session, doc, options);
        }
        return option;
    }

    protected void followTransitionByOption(CoreSession session, Document doc, Map<String, Serializable> options) {
        String lifecycleState = doc.getLifeCycleState();
        if ((APPROVED_STATE.equals(lifecycleState) || OBSOLETE_STATE.equals(lifecycleState)) && doc.getAllowedStateTransitions().contains(BACK_TO_PROJECT_TRANSITION)) {
            doc.followTransition(BACK_TO_PROJECT_TRANSITION);
            if (session != null) {
                this.sendEvent(session, doc, lifecycleState, options);
            }
        }
    }

    public boolean isPostSaveDoingCheckIn(Document doc, VersioningOption option, Map<String, Serializable> options) {
        return doc.isCheckedOut() && option != VersioningOption.NONE;
    }

    public Document doPostSave(CoreSession session, Document doc, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        if (this.isPostSaveDoingCheckIn(doc, option, options)) {
            this.incrementByOption(doc, option);
            return doc.checkIn(null, checkinComment);
        }
        return null;
    }

    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) {
        if (option != VersioningOption.NONE) {
            this.incrementByOption(doc, option == VersioningOption.MAJOR ? VersioningOption.MAJOR : VersioningOption.MINOR);
        }
        return doc.checkIn(null, checkinComment);
    }

    public void doCheckOut(Document doc) {
        Document last;
        Document base = doc.getBaseVersion();
        doc.checkOut();
        if (!base.isLatestVersion() && (last = doc.getLastVersion()) != null) {
            try {
                this.setVersion(doc, this.getMajor(last), this.getMinor(last));
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    @Deprecated
    public Map<String, VersioningRuleDescriptor> getVersioningRules() {
        return Collections.emptyMap();
    }

    @Override
    @Deprecated
    public void setVersioningRules(Map<String, VersioningRuleDescriptor> versioningRules) {
        int order = 9999;
        for (Map.Entry<String, VersioningRuleDescriptor> rules : versioningRules.entrySet()) {
            String documentType = rules.getKey();
            VersioningRuleDescriptor versioningRule = rules.getValue();
            String compatId = COMPAT_ID_PREFIX + documentType;
            if (versioningRule.isEnabled()) {
                VersioningPolicyDescriptor policy = new VersioningPolicyDescriptor();
                policy.id = compatId;
                policy.order = order--;
                policy.initialState = versioningRule.initialState;
                policy.filterIds = new ArrayList<CallSite>(Collections.singleton(compatId));
                VersioningFilterDescriptor filter = new VersioningFilterDescriptor();
                filter.id = compatId;
                filter.types = Collections.singleton(documentType);
                this.versioningPolicies.put(compatId, policy);
                this.versioningFilters.put(compatId, filter);
                VersioningRestrictionDescriptor restriction = new VersioningRestrictionDescriptor();
                restriction.type = documentType;
                restriction.options = versioningRule.getOptions().values().stream().map(SaveOptionsDescriptor::toRestrictionOptions).collect(Collectors.toMap(VersioningRestrictionOptionsDescriptor::getLifeCycleState, Function.identity()));
                this.versioningRestrictions.put(restriction.type, restriction);
                continue;
            }
            this.versioningPolicies.remove(compatId);
            this.versioningFilters.remove(compatId);
        }
    }

    @Override
    @Deprecated
    public void setDefaultVersioningRule(DefaultVersioningRuleDescriptor defaultVersioningRule) {
        if (defaultVersioningRule == null) {
            return;
        }
        VersioningPolicyDescriptor policy = new VersioningPolicyDescriptor();
        policy.id = COMPAT_DEFAULT_ID;
        policy.order = 10000;
        policy.initialState = defaultVersioningRule.initialState;
        if (this.versioningPolicies == null) {
            this.versioningPolicies = new HashMap<String, VersioningPolicyDescriptor>();
        }
        this.versioningPolicies.put(policy.id, policy);
        VersioningRestrictionDescriptor restriction = new VersioningRestrictionDescriptor();
        restriction.type = "*";
        restriction.options = defaultVersioningRule.getOptions().values().stream().map(SaveOptionsDescriptor::toRestrictionOptions).collect(Collectors.toMap(VersioningRestrictionOptionsDescriptor::getLifeCycleState, Function.identity()));
        this.versioningRestrictions.put(restriction.type, restriction);
    }

    @Override
    public void setVersioningPolicies(Map<String, VersioningPolicyDescriptor> versioningPolicies) {
        this.versioningPolicies.clear();
        if (versioningPolicies != null) {
            this.versioningPolicies.putAll(versioningPolicies);
        }
    }

    @Override
    public void setVersioningFilters(Map<String, VersioningFilterDescriptor> versioningFilters) {
        this.versioningFilters.clear();
        if (versioningFilters != null) {
            this.versioningFilters.putAll(versioningFilters);
        }
    }

    @Override
    public void setVersioningRestrictions(Map<String, VersioningRestrictionDescriptor> versioningRestrictions) {
        this.versioningRestrictions.clear();
        if (versioningRestrictions != null) {
            this.versioningRestrictions.putAll(versioningRestrictions);
        }
    }

    public void doAutomaticVersioning(DocumentModel previousDocument, DocumentModel currentDocument, boolean before) {
        VersioningPolicyDescriptor policy = this.retrieveMatchingVersioningPolicy(previousDocument, currentDocument, before);
        if (policy != null && policy.getIncrement() != VersioningOption.NONE) {
            if (before) {
                if (previousDocument.isCheckedOut()) {
                    previousDocument.checkIn(policy.getIncrement(), null);
                    previousDocument.checkOut();
                }
            } else if (currentDocument.isCheckedOut()) {
                currentDocument.checkIn(policy.getIncrement(), null);
            }
        }
    }

    protected VersioningPolicyDescriptor retrieveMatchingVersioningPolicy(DocumentModel previousDocument, DocumentModel currentDocument, boolean before) {
        return this.versioningPolicies.values().stream().filter(policy -> policy.isBeforeUpdate() == before).filter(policy -> policy.getIncrement() != null).sorted().filter(policy -> this.isPolicyMatch((VersioningPolicyDescriptor)policy, previousDocument, currentDocument)).findFirst().orElse(null);
    }

    protected boolean isPolicyMatch(VersioningPolicyDescriptor policyDescriptor, DocumentModel previousDocument, DocumentModel currentDocument) {
        for (String filterId : policyDescriptor.getFilterIds()) {
            VersioningFilterDescriptor filterDescriptor = this.versioningFilters.get(filterId);
            if (filterDescriptor == null) {
                log.warn("Versioning filter with id={} is referenced in the policy with id={}, but doesn't exist.", (Object)filterId, (Object)policyDescriptor.getId());
                continue;
            }
            if (filterDescriptor.newInstance().test(previousDocument, currentDocument)) continue;
            return false;
        }
        log.debug("Document {} is a candidate for {}", (Object)currentDocument.getRef(), (Object)policyDescriptor);
        return true;
    }

    protected void sendEvent(CoreSession session, Document doc, String previousLifecycleState, Map<String, Serializable> options) {
        String sid = session.getSessionId();
        DocumentModelImpl docModel = DocumentModelFactory.createDocumentModel(doc, sid, null);
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), (DocumentModel)docModel);
        ctx.setProperty("from", (Serializable)((Object)previousLifecycleState));
        ctx.setProperty("to", (Serializable)((Object)doc.getLifeCycleState()));
        ctx.setProperty("transition", (Serializable)((Object)BACK_TO_PROJECT_TRANSITION));
        ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        ctx.setProperty("sessionId", (Serializable)((Object)sid));
        ctx.setProperty("documentLifeCycle", (Serializable)((Object)BACK_TO_PROJECT_TRANSITION));
        ctx.setProperty(CATEGORY, (Serializable)((Object)"eventLifeCycleCategory"));
        ctx.setProperty(COMMENT, options.get(COMMENT));
        ((EventService)Framework.getService(EventService.class)).fireEvent(ctx.newEvent("lifecycle_transition_event"));
    }

    private /* synthetic */ boolean lambda$setInitialVersion$1(DocumentModel docModel, VersioningPolicyDescriptor policy) {
        return this.isPolicyMatch(policy, null, docModel);
    }
}

