/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.clients;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class OAuth2ClientReader
extends EntityJsonReader<OAuth2Client> {
    public OAuth2ClientReader() {
        super("oauth2Client");
    }

    protected OAuth2Client readEntity(JsonNode jn) {
        String name = this.getStringField(jn, "name");
        List redirectURIs = Objects.requireNonNullElseGet(this.getStringListField(jn, "redirectURIs"), Collections::emptyList);
        String clientId = this.getStringField(jn, "id");
        String secret = this.getStringField(jn, "secret");
        boolean autoGrant = Objects.requireNonNullElse(this.getBooleanField(jn, "isAutoGrant"), false);
        boolean enabled = Objects.requireNonNullElse(this.getBooleanField(jn, "isEnabled"), false);
        return new OAuth2Client(name, clientId, secret, redirectURIs, autoGrant, enabled);
    }
}

