/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.clients;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuth2ClientServiceImpl
extends DefaultComponent
implements OAuth2ClientService {
    @Override
    public boolean hasClient(String clientId) {
        OAuth2Client client = this.getClient(clientId);
        return client != null && client.isEnabled();
    }

    @Override
    public boolean isValidClient(String clientId, String clientSecret) {
        OAuth2Client client = this.getClient(clientId);
        return client != null && client.isValidWith(clientId, clientSecret);
    }

    @Override
    public OAuth2Client getClient(String clientId) {
        DocumentModel doc = this.getClientModel(clientId);
        if (doc == null) {
            return null;
        }
        return OAuth2Client.fromDocumentModel(doc);
    }

    @Override
    public List<OAuth2Client> getClients() {
        return this.queryClients().stream().map(OAuth2Client::fromDocumentModel).collect(Collectors.toList());
    }

    @Override
    public OAuth2Client create(OAuth2Client oAuth2Client, NuxeoPrincipal principal) {
        this.validate(oAuth2Client);
        this.checkUnicity(oAuth2Client.getId());
        return this.execute(session -> {
            DocumentModel documentModel = OAuth2Client.fromOAuth2Client(oAuth2Client);
            return OAuth2Client.fromDocumentModel(session.createEntry(documentModel));
        }, principal);
    }

    @Override
    public OAuth2Client update(String clientId, OAuth2Client oAuth2Client, NuxeoPrincipal principal) {
        this.validate(oAuth2Client);
        if (!oAuth2Client.getId().equals(clientId)) {
            this.checkUnicity(oAuth2Client.getId());
        }
        DocumentModel doc = this.getDocument(clientId);
        return this.execute(session -> {
            DocumentModel documentModel = OAuth2Client.updateDocument(doc, oAuth2Client);
            session.updateEntry(documentModel);
            return OAuth2Client.fromDocumentModel(documentModel);
        }, principal);
    }

    @Override
    public void delete(String clientId, NuxeoPrincipal principal) {
        DocumentModel document = this.getDocument(clientId);
        this.execute(session -> {
            session.deleteEntry(document);
            return null;
        }, principal);
    }

    protected DocumentModel getClientModel(String clientId) {
        return this.execute(session -> {
            Map<String, String> filter = Collections.singletonMap("clientId", clientId);
            DocumentModelList docs = session.query(filter);
            if (docs.size() == 1) {
                return (DocumentModel)docs.get(0);
            }
            if (docs.size() > 1) {
                throw new NuxeoException(String.format("More than one client registered for the '%s' id", clientId));
            }
            return null;
        });
    }

    protected List<DocumentModel> queryClients() {
        return (List)this.execute(session -> session.query(Collections.emptyMap()));
    }

    protected <T> T execute(Function<Session, T> function) {
        return this.execute(function, null);
    }

    protected <T> T execute(Function<Session, T> function, NuxeoPrincipal principal) {
        if (principal != null) {
            this.checkPermission(principal);
        }
        DirectoryService service = (DirectoryService)Framework.getService(DirectoryService.class);
        return (T)Framework.doPrivileged(() -> {
            try (Session session = service.open("oauth2Clients");){
                Object r = function.apply(session);
                return r;
            }
        });
    }

    protected void checkPermission(NuxeoPrincipal principal) {
        if (!principal.isAdministrator()) {
            throw new NuxeoException("You do not have permissions to perform this operation.", 403);
        }
    }

    protected void validate(OAuth2Client oAuth2Client) {
        Objects.requireNonNull(oAuth2Client, "oAuth2Client is required");
        String message = StringUtils.isBlank((CharSequence)oAuth2Client.getName()) ? "Client name is required" : (StringUtils.isBlank((CharSequence)oAuth2Client.getId()) ? "Client Id is required" : (oAuth2Client.getRedirectURIs().isEmpty() ? "Redirect URIs is required" : (String)oAuth2Client.getRedirectURIs().stream().filter(uri -> !OAuth2Client.isRedirectURIValid(uri)).findAny().map(uri -> String.format("'%s' is not a valid redirect URI", uri)).orElse(null)));
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            throw new NuxeoException(String.format("%s", message), 400);
        }
    }

    protected void checkUnicity(String clientId) {
        if (this.getClientModel(clientId) != null) {
            throw new NuxeoException(String.format("Client with id '%s' already exists", clientId), 400);
        }
    }

    protected DocumentModel getDocument(String clientId) {
        DocumentModel doc = this.getClientModel(clientId);
        if (doc == null) {
            throw new NuxeoException(404);
        }
        return doc;
    }
}

