/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderContributionRegistry;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderDescriptor;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuth2ServiceProviderRegistryImpl
extends DefaultComponent
implements OAuth2ServiceProviderRegistry {
    protected static final Log log = LogFactory.getLog(OAuth2ServiceProviderRegistryImpl.class);
    public static final String PROVIDER_EP = "providers";
    public static final String DIRECTORY_NAME = "oauth2ServiceProviders";
    public static final String SCHEMA = "oauth2ServiceProvider";
    protected OAuth2ServiceProviderContributionRegistry registry = new OAuth2ServiceProviderContributionRegistry();

    protected DocumentModel getProviderDocModel(String serviceName) {
        try {
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                log.warn((Object)"Can not find provider without a serviceName!");
                return null;
            }
            HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
            filter.put("serviceName", (Serializable)((Object)serviceName));
            List<DocumentModel> providers = this.queryProviders(filter, 1);
            return providers.isEmpty() ? null : providers.get(0);
        }
        catch (DirectoryException e) {
            log.error((Object)"Unable to read provider from Directory backend", (Throwable)e);
            return null;
        }
    }

    @Override
    public OAuth2ServiceProvider getProvider(String serviceName) {
        DocumentModel model = this.getProviderDocModel(serviceName);
        return model == null ? null : this.buildProvider(model);
    }

    @Override
    public List<OAuth2ServiceProvider> getProviders() {
        List<DocumentModel> providers = this.queryProviders(Collections.emptyMap(), 0);
        return providers.stream().map(this::buildProvider).collect(Collectors.toList());
    }

    @Override
    public OAuth2ServiceProvider addProvider(String serviceName, String description, String tokenServerURL, String authorizationServerURL, String clientId, String clientSecret, List<String> scopes) {
        return this.addProvider(serviceName, description, tokenServerURL, authorizationServerURL, null, clientId, clientSecret, scopes, Boolean.TRUE);
    }

    @Override
    public OAuth2ServiceProvider addProvider(String serviceName, String description, String tokenServerURL, String authorizationServerURL, String userAuthorizationURL, String clientId, String clientSecret, List<String> scopes, Boolean isEnabled) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            DocumentModel creationEntry = BaseSession.createEntryModel(null, (String)SCHEMA, null, null);
            DocumentModel entry = (DocumentModel)Framework.doPrivileged(() -> session.createEntry(creationEntry));
            entry.setProperty(SCHEMA, "serviceName", (Object)serviceName);
            entry.setProperty(SCHEMA, "description", (Object)description);
            entry.setProperty(SCHEMA, "authorizationServerURL", (Object)authorizationServerURL);
            entry.setProperty(SCHEMA, "tokenServerURL", (Object)tokenServerURL);
            entry.setProperty(SCHEMA, "userAuthorizationURL", (Object)userAuthorizationURL);
            entry.setProperty(SCHEMA, "clientId", (Object)clientId);
            entry.setProperty(SCHEMA, "clientSecret", (Object)clientSecret);
            entry.setProperty(SCHEMA, "scopes", (Object)String.join((CharSequence)",", scopes));
            boolean enabled = clientId != null && clientSecret != null;
            entry.setProperty(SCHEMA, "enabled", (Object)(enabled && isEnabled != null && isEnabled != false ? 1 : 0));
            if (!enabled) {
                log.info((Object)("OAuth2 provider for " + serviceName + " is disabled because clientId and/or clientSecret are empty"));
            }
            Framework.doPrivileged(() -> session.updateEntry(entry));
            OAuth2ServiceProvider oAuth2ServiceProvider = this.getProvider(serviceName);
            return oAuth2ServiceProvider;
        }
    }

    @Override
    public OAuth2ServiceProvider updateProvider(String serviceName, OAuth2ServiceProvider provider) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            DocumentModel entry = this.getProviderDocModel(serviceName);
            entry.setProperty(SCHEMA, "serviceName", (Object)provider.getServiceName());
            entry.setProperty(SCHEMA, "description", (Object)provider.getDescription());
            entry.setProperty(SCHEMA, "authorizationServerURL", (Object)provider.getAuthorizationServerURL());
            entry.setProperty(SCHEMA, "tokenServerURL", (Object)provider.getTokenServerURL());
            entry.setProperty(SCHEMA, "userAuthorizationURL", (Object)provider.getUserAuthorizationURL());
            entry.setProperty(SCHEMA, "clientId", (Object)provider.getClientId());
            entry.setProperty(SCHEMA, "clientSecret", (Object)provider.getClientSecret());
            entry.setProperty(SCHEMA, "scopes", (Object)String.join((CharSequence)",", provider.getScopes()));
            boolean enabled = provider.getClientId() != null && provider.getClientSecret() != null;
            entry.setProperty(SCHEMA, "enabled", (Object)(enabled && provider.isEnabled() ? 1 : 0));
            if (!enabled) {
                log.info((Object)("OAuth2 provider for " + serviceName + " is disabled because clientId and/or clientSecret are empty"));
            }
            session.updateEntry(entry);
            OAuth2ServiceProvider oAuth2ServiceProvider = this.getProvider(serviceName);
            return oAuth2ServiceProvider;
        }
    }

    @Override
    public void deleteProvider(String serviceName) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            DocumentModel entry = this.getProviderDocModel(serviceName);
            session.deleteEntry(entry);
        }
    }

    protected List<DocumentModel> queryProviders(Map<String, Serializable> filter, int limit) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        return (List)Framework.doPrivileged(() -> {
            DocumentModelList documentModelList;
            block8: {
                Session session = ds.open(DIRECTORY_NAME);
                try {
                    Set fulltext = Collections.emptySet();
                    Map orderBy = Collections.emptyMap();
                    documentModelList = session.query(filter, fulltext, orderBy, true, limit, 0);
                    if (session == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DirectoryException e) {
                        log.error((Object)"Error while fetching provider directory", (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                session.close();
            }
            return documentModelList;
        });
    }

    protected OAuth2ServiceProvider buildProvider(DocumentModel entry) {
        String serviceName = (String)entry.getProperty(SCHEMA, "serviceName");
        OAuth2ServiceProvider provider = this.registry.getProvider(serviceName);
        if (provider == null) {
            provider = new NuxeoOAuth2ServiceProvider();
            provider.setServiceName(serviceName);
        }
        provider.setId((Long)entry.getProperty(SCHEMA, "id"));
        provider.setDescription((String)entry.getProperty(SCHEMA, "description"));
        provider.setAuthorizationServerURL((String)entry.getProperty(SCHEMA, "authorizationServerURL"));
        provider.setTokenServerURL((String)entry.getProperty(SCHEMA, "tokenServerURL"));
        provider.setUserAuthorizationURL((String)entry.getProperty(SCHEMA, "userAuthorizationURL"));
        provider.setClientId((String)entry.getProperty(SCHEMA, "clientId"));
        provider.setClientSecret((String)entry.getProperty(SCHEMA, "clientSecret"));
        String scopes = (String)entry.getProperty(SCHEMA, "scopes");
        provider.setScopes(StringUtils.split((String)scopes, (String)","));
        provider.setEnabled((Boolean)entry.getProperty(SCHEMA, "enabled"));
        return provider;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PROVIDER_EP.equals(extensionPoint)) {
            OAuth2ServiceProviderDescriptor provider = (OAuth2ServiceProviderDescriptor)contribution;
            log.info((Object)("OAuth2 provider for " + provider.getName() + " will be registered at application startup"));
            this.registry.addContribution(provider);
        }
    }

    public void start(ComponentContext context) {
        this.registerCustomProviders();
    }

    protected void registerCustomProviders() {
        for (OAuth2ServiceProviderDescriptor provider : this.registry.getContribs()) {
            if (this.getProvider(provider.getName()) == null) {
                this.addProvider(provider.getName(), provider.getDescription(), provider.getTokenServerURL(), provider.getAuthorizationServerURL(), provider.getClientId(), provider.getClientSecret(), Arrays.asList(provider.getScopes()));
                continue;
            }
            log.info((Object)("Provider " + provider.getName() + " is already in the Database, XML contribution  won't overwrite it"));
        }
    }
}

