/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.ReadOnlyVec;
import org.sat4j.core.ReadOnlyVecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coeffs;
    private final IVecInt vars;
    private BigInteger correction = BigInteger.ZERO;

    public ObjectiveFunction(IVecInt vars, IVec<BigInteger> coeffs) {
        this.vars = new ReadOnlyVecInt(vars);
        this.coeffs = new ReadOnlyVec(coeffs);
    }

    public BigInteger calculateDegree(ISolver solver) {
        BigInteger tempDegree = BigInteger.ZERO;
        int i = 0;
        while (i < this.vars.size()) {
            BigInteger coeff = (BigInteger)this.coeffs.get(i);
            if (this.varInModel(this.vars.get(i), solver)) {
                tempDegree = tempDegree.add(coeff);
            } else if (coeff.signum() < 0 && !this.varInModel(-this.vars.get(i), solver)) {
                tempDegree = tempDegree.add(coeff);
            }
            ++i;
        }
        return tempDegree;
    }

    private boolean varInModel(int var, ISolver solver) {
        if (var > 0) {
            return solver.model(var);
        }
        return !solver.model(-var);
    }

    public IVec<BigInteger> getCoeffs() {
        return this.coeffs;
    }

    public IVecInt getVars() {
        return this.vars;
    }

    public void setCorrection(BigInteger correction) {
        this.correction = correction;
    }

    public BigInteger getCorrection() {
        return this.correction;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        IVecInt lits = this.getVars();
        IVec<BigInteger> coefs = this.getCoeffs();
        int i = 0;
        while (i < lits.size()) {
            BigInteger coef = (BigInteger)coefs.get(i);
            int lit = lits.get(i);
            if (lit < 0) {
                lit = -lit;
                coef = coef.negate();
            }
            stb.append(new StringBuffer(String.valueOf(coef.signum() < 0 ? "" : "+")).append(coef).append(" x").append(lit).append(" ").toString());
            ++i;
        }
        return stb.toString();
    }

    public BigInteger minValue() {
        BigInteger tempDegree = BigInteger.ZERO;
        int i = 0;
        while (i < this.vars.size()) {
            BigInteger coeff = (BigInteger)this.coeffs.get(i);
            if (coeff.signum() < 0) {
                tempDegree = tempDegree.add(coeff);
            }
            ++i;
        }
        return tempDegree;
    }
}

