/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryEntryType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeContainer;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

@MTOM
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort")
public class RepositoryService
extends AbstractService
implements RepositoryServicePort {
    @Resource
    public WebServiceContext wsContext;

    public List<CmisRepositoryEntryType> getRepositories(CmisExtensionType extension) throws CmisException {
        ArrayList<CmisRepositoryEntryType> arrayList;
        List infoDataList;
        CmisService service;
        block10: {
            block9: {
                block8: {
                    service = null;
                    service = this.getServiceForRepositoryInfo(this.wsContext, null);
                    if (!this.stopBeforeService(service)) break block8;
                    List<CmisRepositoryEntryType> list = null;
                    this.closeService(service);
                    return list;
                }
                infoDataList = service.getRepositoryInfos(WSConverter.convert((CmisExtensionType)extension));
                if (!this.stopAfterService(service)) break block9;
                List<CmisRepositoryEntryType> list = null;
                this.closeService(service);
                return list;
            }
            if (infoDataList != null) break block10;
            List<CmisRepositoryEntryType> list = null;
            this.closeService(service);
            return list;
        }
        try {
            ArrayList<CmisRepositoryEntryType> result = new ArrayList<CmisRepositoryEntryType>();
            for (RepositoryInfo infoData : infoDataList) {
                CmisRepositoryEntryType entry = new CmisRepositoryEntryType();
                entry.setRepositoryId(infoData.getId());
                entry.setRepositoryName(infoData.getName());
                result.add(entry);
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public CmisRepositoryInfoType getRepositoryInfo(String repositoryId, CmisExtensionType extension) throws CmisException {
        CmisRepositoryInfoType cmisRepositoryInfoType;
        RepositoryInfo serviceResult;
        CmisVersion cmisVersion;
        CmisService service;
        block7: {
            block6: {
                service = null;
                cmisVersion = null;
                service = this.getServiceForRepositoryInfo(this.wsContext, repositoryId);
                cmisVersion = this.getCmisVersion(this.wsContext);
                if (!this.stopBeforeService(service)) break block6;
                CmisRepositoryInfoType cmisRepositoryInfoType2 = null;
                this.closeService(service);
                return cmisRepositoryInfoType2;
            }
            serviceResult = service.getRepositoryInfo(repositoryId, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisRepositoryInfoType cmisRepositoryInfoType3 = null;
            this.closeService(service);
            return cmisRepositoryInfoType3;
        }
        try {
            cmisRepositoryInfoType = WSConverter.convert((RepositoryInfo)serviceResult, (CmisVersion)cmisVersion);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisRepositoryInfoType;
    }

    public CmisTypeDefinitionListType getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        CmisTypeDefinitionListType cmisTypeDefinitionListType;
        TypeDefinitionList serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                CmisTypeDefinitionListType cmisTypeDefinitionListType2 = null;
                this.closeService(service);
                return cmisTypeDefinitionListType2;
            }
            serviceResult = service.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisTypeDefinitionListType cmisTypeDefinitionListType3 = null;
            this.closeService(service);
            return cmisTypeDefinitionListType3;
        }
        try {
            cmisTypeDefinitionListType = WSConverter.convert((TypeDefinitionList)serviceResult);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisTypeDefinitionListType;
    }

    public CmisTypeDefinitionType getTypeDefinition(String repositoryId, String typeId, CmisExtensionType extension) throws CmisException {
        CmisTypeDefinitionType cmisTypeDefinitionType;
        TypeDefinition serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                CmisTypeDefinitionType cmisTypeDefinitionType2 = null;
                this.closeService(service);
                return cmisTypeDefinitionType2;
            }
            serviceResult = service.getTypeDefinition(repositoryId, typeId, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisTypeDefinitionType cmisTypeDefinitionType3 = null;
            this.closeService(service);
            return cmisTypeDefinitionType3;
        }
        try {
            cmisTypeDefinitionType = WSConverter.convert((TypeDefinition)serviceResult);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisTypeDefinitionType;
    }

    public List<CmisTypeContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisTypeContainer> arrayList;
        List serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                List<CmisTypeContainer> list = null;
                this.closeService(service);
                return list;
            }
            serviceResult = service.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            List<CmisTypeContainer> list = null;
            this.closeService(service);
            return list;
        }
        try {
            ArrayList<CmisTypeContainer> result = new ArrayList<CmisTypeContainer>();
            WSConverter.convertTypeContainerList((List)serviceResult, result);
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public void createType(String repositoryId, Holder<CmisTypeDefinitionType> type, CmisExtensionType extension) throws CmisException {
        TypeDefinition serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            serviceResult = service.createType(repositoryId, WSConverter.convert((CmisTypeDefinitionType)((CmisTypeDefinitionType)type.value)), WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            type.value = WSConverter.convert((TypeDefinition)serviceResult);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void updateType(String repositoryId, Holder<CmisTypeDefinitionType> type, CmisExtensionType extension) throws CmisException {
        TypeDefinition serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            serviceResult = service.updateType(repositoryId, WSConverter.convert((CmisTypeDefinitionType)((CmisTypeDefinitionType)type.value)), WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            type.value = WSConverter.convert((TypeDefinition)serviceResult);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void deleteType(String repositoryId, String typeId, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.deleteType(repositoryId, typeId, extData);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }
}

