/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.security.guards;

import java.security.Principal;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.security.Guard;
import org.nuxeo.runtime.model.Adaptable;

@XObject(value="isAdministrator")
public class IsAdministratorGuard
implements Guard {
    protected boolean isAdministrator;

    public IsAdministratorGuard() {
        this.isAdministrator = true;
    }

    public IsAdministratorGuard(String isAdministrator) {
        this.isAdministrator = Boolean.parseBoolean(isAdministrator);
    }

    public IsAdministratorGuard(Access isAdministrator) {
        this.isAdministrator = isAdministrator == Access.GRANT;
    }

    @Override
    public boolean check(Adaptable context) {
        Principal p = (Principal)context.getAdapter(Principal.class);
        if (p instanceof NuxeoPrincipal) {
            return ((NuxeoPrincipal)p).isAdministrator() == this.isAdministrator;
        }
        return false;
    }

    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    public String toString() {
        return "IS_ADMINISTRATOR[" + this.isAdministrator + "]";
    }
}

