/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.support;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.WroServletContextListener;
import ro.isdc.wro.manager.factory.WroManagerFactory;

public class ServletContextAttributeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(WroServletContextListener.class);
    static final String INIT_PARAM_NAME = "name";
    public static final String DEFAULT_NAME = "default";
    private ServletContext servletContext;
    private String name;

    public ServletContextAttributeHelper(ServletContext servletContext) {
        this(servletContext, DEFAULT_NAME);
    }

    public static ServletContextAttributeHelper create(FilterConfig filterConfig) {
        Validate.notNull((Object)filterConfig);
        String nameFromParam = filterConfig.getInitParameter(INIT_PARAM_NAME);
        String name = nameFromParam != null ? nameFromParam : DEFAULT_NAME;
        return new ServletContextAttributeHelper(filterConfig.getServletContext(), name);
    }

    public ServletContextAttributeHelper(ServletContext servletContext, String name) {
        Validate.notNull((Object)servletContext);
        Validate.notBlank((CharSequence)name);
        this.servletContext = servletContext;
        this.name = name;
        LOG.debug("initializing attributeHelper named: {}", (Object)name);
    }

    final String getAttributeName(Attribute attribute) {
        Validate.notNull((Object)((Object)attribute));
        return WroServletContextListener.class.getName() + "-" + attribute.name() + "-" + this.name;
    }

    final Object getAttribute(Attribute attribute) {
        Validate.notNull((Object)((Object)attribute));
        return this.servletContext.getAttribute(this.getAttributeName(attribute));
    }

    public WroManagerFactory getManagerFactory() {
        return (WroManagerFactory)this.getAttribute(Attribute.MANAGER_FACTORY);
    }

    public WroConfiguration getWroConfiguration() {
        return (WroConfiguration)this.getAttribute(Attribute.CONFIGURATION);
    }

    final void setAttribute(Attribute attribute, Object object) {
        Validate.notNull((Object)((Object)attribute));
        LOG.debug("setting attribute: {} with value: {}", (Object)attribute, object);
        Validate.isTrue((boolean)attribute.isValid(object), (String)(object + " is not of valid subType for attribute: " + (Object)((Object)attribute)), (Object[])new Object[0]);
        this.servletContext.setAttribute(this.getAttributeName(attribute), object);
    }

    public void setWroConfiguration(WroConfiguration config) {
        this.setAttribute(Attribute.CONFIGURATION, config);
    }

    public void setManagerFactory(WroManagerFactory managerFactory) {
        this.setAttribute(Attribute.MANAGER_FACTORY, managerFactory);
    }

    public void clear() {
        LOG.debug("destroying servletContext: {}", (Object)this.name);
        for (Attribute attribute : Attribute.values()) {
            this.servletContext.removeAttribute(this.getAttributeName(attribute));
        }
    }

    final String getName() {
        return this.name;
    }

    static enum Attribute {
        CONFIGURATION(WroConfiguration.class),
        MANAGER_FACTORY(WroManagerFactory.class);

        private Class<?> type;

        private Attribute(Class<?> type) {
            this.type = type;
        }

        boolean isValid(Object object) {
            return object == null || this.type.isAssignableFrom(object.getClass());
        }
    }
}

