/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.callback;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.manager.callback.LifecycleCallback;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.util.Function;
import ro.isdc.wro.util.ObjectFactory;

public class LifecycleCallbackRegistry
implements LifecycleCallback {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleCallbackRegistry.class);
    private final List<ObjectFactory<LifecycleCallback>> callbackFactoryList = new ArrayList<ObjectFactory<LifecycleCallback>>();
    private final Map<String, List<LifecycleCallback>> map = new ConcurrentHashMap<String, List<LifecycleCallback>>();

    public void registerCallback(ObjectFactory<LifecycleCallback> callbackFactory) {
        this.callbackFactoryList.add(callbackFactory);
    }

    private List<LifecycleCallback> getCallbacks() {
        String key = Context.getCorrelationId();
        List<LifecycleCallback> callbacks = this.map.get(key);
        if (callbacks == null) {
            callbacks = this.initCallbacks();
            this.map.put(key, callbacks);
        }
        return callbacks;
    }

    protected List<LifecycleCallback> initCallbacks() {
        ArrayList<LifecycleCallback> callbacks = new ArrayList<LifecycleCallback>();
        for (ObjectFactory<LifecycleCallback> callbackFactory : this.callbackFactoryList) {
            callbacks.add(callbackFactory.create());
        }
        return callbacks;
    }

    @Override
    public void onBeforeModelCreated() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onBeforeModelCreated();
                return null;
            }
        });
    }

    @Override
    public void onAfterModelCreated() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onAfterModelCreated();
                return null;
            }
        });
    }

    @Override
    public void onBeforePreProcess() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onBeforePreProcess();
                return null;
            }
        });
    }

    @Override
    public void onAfterPreProcess() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onAfterPreProcess();
                return null;
            }
        });
    }

    @Override
    public void onBeforePostProcess() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onBeforePostProcess();
                return null;
            }
        });
    }

    @Override
    public void onAfterPostProcess() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onAfterPostProcess();
                return null;
            }
        });
    }

    @Override
    public void onBeforeMerge() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onBeforeMerge();
                return null;
            }
        });
    }

    @Override
    public void onAfterMerge() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onAfterMerge();
                return null;
            }
        });
    }

    @Override
    public void onProcessingComplete() {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onProcessingComplete();
                return null;
            }
        });
    }

    @Override
    public void onResourceChanged(final Resource resource) {
        this.forEachCallbackDo(new Function<LifecycleCallback, Void>(){

            @Override
            public Void apply(LifecycleCallback input) throws Exception {
                input.onResourceChanged(resource);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachCallbackDo(Function<LifecycleCallback, Void> func) {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                func.apply(callback);
            }
            catch (Exception e) {
                LOG.error("Problem invoking callback", (Throwable)e);
                this.onException(e);
            }
            finally {
                this.map.remove(Context.getCorrelationId());
            }
        }
    }

    protected void onException(Exception e) {
    }
}

