/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.jmx.ConfigConstants;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.config.support.PropertiesFactory;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.ConfigurableWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.util.ObjectFactory;

public class DefaultWroManagerFactory
implements WroManagerFactory {
    private final WroManagerFactory factory;

    public static DefaultWroManagerFactory create(final WroConfiguration configuration) {
        return DefaultWroManagerFactory.create(new ObjectFactory<WroConfiguration>(){

            @Override
            public WroConfiguration create() {
                return configuration;
            }
        });
    }

    public static DefaultWroManagerFactory create(ObjectFactory<WroConfiguration> configurationFactory) {
        Validate.notNull(configurationFactory);
        Properties properties = configurationFactory instanceof PropertiesFactory ? ((PropertiesFactory)((Object)configurationFactory)).createProperties() : new Properties();
        String wroManagerClassName = configurationFactory.create().getWroManagerClassName();
        if (wroManagerClassName != null) {
            properties.setProperty(ConfigConstants.managerFactoryClassName.name(), wroManagerClassName);
        }
        return new DefaultWroManagerFactory(properties);
    }

    public DefaultWroManagerFactory(Properties properties) {
        Validate.notNull((Object)properties);
        this.factory = this.initFactory(properties);
    }

    private WroManagerFactory initFactory(Properties properties) {
        WroManagerFactory factory = null;
        String wroManagerClassName = properties.getProperty(ConfigConstants.managerFactoryClassName.name());
        if (StringUtils.isEmpty((CharSequence)wroManagerClassName)) {
            factory = this.newManagerFactory();
        } else {
            Class<?> factoryClass = null;
            try {
                factoryClass = Thread.currentThread().getContextClassLoader().loadClass(wroManagerClassName);
                factory = (WroManagerFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new WroRuntimeException("Exception while loading WroManagerFactory class:" + wroManagerClassName, e);
            }
        }
        if (factory instanceof ConfigurableWroManagerFactory) {
            ((ConfigurableWroManagerFactory)factory).addConfigProperties(properties);
        }
        return factory;
    }

    WroManagerFactory newManagerFactory() {
        return new ConfigurableWroManagerFactory();
    }

    @Override
    public void onCachePeriodChanged(long value) {
        this.factory.onCachePeriodChanged(value);
    }

    @Override
    public void onModelPeriodChanged(long value) {
        this.factory.onModelPeriodChanged(value);
    }

    @Override
    public WroManager create() {
        return (WroManager)this.factory.create();
    }

    @Override
    public void destroy() {
        this.factory.destroy();
    }

    public final WroManagerFactory getFactory() {
        return this.factory;
    }

    public String toString() {
        return this.factory.toString();
    }
}

