/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.factory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.WroModelFactoryDecorator;

public class FallbackAwareWroModelFactory
extends WroModelFactoryDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackAwareWroModelFactory.class);
    private WroModel lastValidModel;

    public FallbackAwareWroModelFactory(WroModelFactory decorated) {
        super(decorated);
    }

    @Override
    public WroModel create() {
        WroModel newModel = null;
        try {
            newModel = super.create();
        }
        catch (WroRuntimeException e) {
            LOG.error("Error while creating the model", (Throwable)e);
        }
        if (newModel == null) {
            LOG.warn("Couldn't load new model, reusing last Valid Model!");
            if (this.lastValidModel == null) {
                throw new WroRuntimeException("No valid model was found!");
            }
            return this.lastValidModel;
        }
        this.lastValidModel = newModel;
        return this.lastValidModel;
    }
}

