/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.decorator;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.decorator.BenchmarkProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ExceptionHandlingProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ImportAwareProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.MinimizeAwareProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.SupportAwareProcessorDecorator;
import ro.isdc.wro.model.resource.processor.support.ProcessingCriteria;

public class DefaultProcessorDecorator
extends ProcessorDecorator {
    private final ProcessingCriteria criteria;

    public DefaultProcessorDecorator(Object processor, boolean minimize) {
        this(processor, ProcessingCriteria.createDefault(minimize));
    }

    public DefaultProcessorDecorator(Object processor, ProcessingCriteria criteria) {
        super(DefaultProcessorDecorator.decorate(processor, criteria));
        this.criteria = criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            super.process(resource, reader, writer);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private static ProcessorDecorator decorate(Object processor, ProcessingCriteria criteria) {
        Validate.notNull((Object)criteria);
        return new BenchmarkProcessorDecorator(new ExceptionHandlingProcessorDecorator(new SupportAwareProcessorDecorator(new MinimizeAwareProcessorDecorator(new ImportAwareProcessorDecorator(processor, criteria.getProcessingType())))));
    }

    @Override
    protected boolean isEnabled(Resource resource) {
        boolean isApplicable = resource != null ? this.isEligible(this.criteria.isMinimize(), resource.getType()) : true;
        return super.isEnabled(resource) && isApplicable;
    }
}

