/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.data;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.marshaling.JSONExportMethod;
import org.nuxeo.connect.data.marshaling.JSONExportableField;

public class IntrospectionHelper {
    protected static Map<String, Map<String, Object>> readDataStructures = new HashMap<String, Map<String, Object>>();
    protected static Map<String, Map<String, Object>> writeDataStructures = new HashMap<String, Map<String, Object>>();

    public static Map<String, Object> getDataToSerialize(AbstractJSONSerializableData targetInstance) {
        Map<String, Object> dataStructure = readDataStructures.get(targetInstance.getClass().getName());
        if (dataStructure == null) {
            dataStructure = new HashMap<String, Object>();
            IntrospectionHelper.fetchDataStructureToSerialize(dataStructure, targetInstance.getClass());
            readDataStructures.put(targetInstance.getClass().getName(), dataStructure);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (String key : dataStructure.keySet()) {
            Object fieldOrMethod = dataStructure.get(key);
            if (fieldOrMethod instanceof Method) {
                Method method = (Method)fieldOrMethod;
                try {
                    data.put(key, method.invoke((Object)targetInstance, (Object[])null));
                }
                catch (Exception exception) {}
                continue;
            }
            if (!(fieldOrMethod instanceof Field)) continue;
            Field field = (Field)fieldOrMethod;
            try {
                data.put(key, field.get(targetInstance));
            }
            catch (Exception exception) {}
        }
        return data;
    }

    protected static void fetchDataStructureToSerialize(Map<String, Object> data, Class<?> klass) {
        Class<?> parentKlass = klass.getSuperclass();
        if (parentKlass != null) {
            IntrospectionHelper.fetchDataStructureToSerialize(data, parentKlass);
        }
        for (Field field : klass.getDeclaredFields()) {
            if (field.getAnnotation(JSONExportableField.class) == null) continue;
            try {
                data.put(field.getName(), field);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : klass.getDeclaredMethods()) {
            if (((Method)accessibleObject).getAnnotation(JSONExportMethod.class) == null) continue;
            try {
                data.put(((Method)accessibleObject).getAnnotation(JSONExportMethod.class).name(), accessibleObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

