/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.tag.AbstractTagService;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;

@Deprecated
public class RelationTagService
extends AbstractTagService {
    public boolean hasFeature(TagService.Feature feature) {
        switch (feature) {
            case TAGS_BELONG_TO_DOCUMENT: {
                return false;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }

    public boolean supportsTag(CoreSession session, String docId) {
        return true;
    }

    @Override
    public void doTag(CoreSession session, String docId, String label, String username) {
        if (session.getDocument((DocumentRef)new IdRef(docId)).isProxy()) {
            throw new NuxeoException("Adding tags is not allowed on proxies");
        }
        List<Map<String, Serializable>> res = RelationTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_DOCUMENT_IDS_FOR_TAG.name(), session, label);
        String tagId = res != null && !res.isEmpty() ? (String)((Object)res.get(0).get("ecm:uuid")) : null;
        Calendar date = Calendar.getInstance();
        if (tagId == null) {
            DocumentModel tag = session.createDocumentModel(null, label, "Tag");
            tag.setPropertyValue("dc:created", (Serializable)date);
            tag.setPropertyValue("tag:label", (Serializable)((Object)label));
            tag = session.createDocument(tag);
            tagId = tag.getId();
        }
        if ((res = RelationTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_FIRST_TAGGING_FOR_DOC_AND_TAG.name(), session, docId, tagId)) != null && !res.isEmpty()) {
            return;
        }
        DocumentModel tagging = session.createDocumentModel(null, label, "Tagging");
        tagging.setPropertyValue("dc:created", (Serializable)date);
        tagging.setPropertyValue("dc:creator", (Serializable)((Object)username));
        tagging.setPropertyValue("relation:source", (Serializable)((Object)docId));
        tagging.setPropertyValue("relation:target", (Serializable)((Object)tagId));
        session.createDocument(tagging);
        session.save();
    }

    @Override
    public void doUntag(CoreSession session, String docId, String label) {
        IdRef ref = new IdRef(docId);
        if (session.exists((DocumentRef)ref) && session.getDocument((DocumentRef)ref).isProxy()) {
            throw new NuxeoException("Removing tags is not allowed on proxies");
        }
        String tagId = null;
        if (label != null) {
            List<Map<String, Serializable>> res = RelationTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_DOCUMENT_IDS_FOR_TAG.name(), session, label);
            String string = tagId = res != null && !res.isEmpty() ? (String)((Object)res.get(0).get("ecm:uuid")) : null;
            if (tagId == null) {
                return;
            }
        }
        HashSet<String> taggingIds = new HashSet<String>();
        Object query = String.format("SELECT ecm:uuid FROM Tagging WHERE relation:source = '%s'", docId);
        if (tagId != null) {
            query = (String)query + String.format(" AND relation:target = '%s'", tagId);
        }
        try (IterableQueryResult res = session.queryAndFetch((String)query, "NXQL", new Object[0]);){
            for (Map map : res) {
                taggingIds.add((String)map.get("ecm:uuid"));
            }
        }
        for (String taggingId : taggingIds) {
            session.removeDocument((DocumentRef)new IdRef(taggingId));
        }
        if (!taggingIds.isEmpty()) {
            session.save();
        }
    }

    @Override
    public Set<String> doGetTags(CoreSession session, String docId) {
        List<Map<String, Serializable>> res = RelationTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENT.name(), session, docId);
        if (res == null) {
            return Collections.emptySet();
        }
        return res.stream().map(m -> (String)m.get("tag:label")).collect(Collectors.toSet());
    }

    @Override
    public void doCopyTags(CoreSession session, String srcDocId, String dstDocId, boolean removeExistingTags) {
        List<Map<String, Serializable>> srcTagsRes;
        if (removeExistingTags) {
            this.doUntag(session, dstDocId, null);
        }
        HashSet<String> existingTags = new HashSet<String>();
        List<Map<String, Serializable>> dstTagsRes = RelationTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_TAGS_TO_COPY_FOR_DOCUMENT.name(), session, dstDocId);
        if (dstTagsRes != null) {
            for (Map<String, Serializable> map : dstTagsRes) {
                existingTags.add(String.format("%s/%s", map.get("tag:label"), map.get("dc:creator")));
            }
        }
        if ((srcTagsRes = RelationTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_TAGS_TO_COPY_FOR_DOCUMENT.name(), session, srcDocId)) != null) {
            boolean docCreated = false;
            for (Map<String, Serializable> map : srcTagsRes) {
                String key = String.format("%s/%s", map.get("tag:label"), map.get("dc:creator"));
                if (existingTags.contains(key)) continue;
                DocumentModel tagging = session.createDocumentModel(null, (String)((Object)map.get("tag:label")), "Tagging");
                tagging.setPropertyValue("dc:created", map.get("dc:created"));
                tagging.setPropertyValue("dc:creator", map.get("dc:creator"));
                tagging.setPropertyValue("relation:source", (Serializable)((Object)dstDocId));
                tagging.setPropertyValue("relation:target", map.get("relation:target"));
                session.createDocument(tagging);
                docCreated = true;
            }
            if (docCreated) {
                session.save();
            }
        }
    }

    @Override
    public List<String> doGetTagDocumentIds(CoreSession session, String label) {
        List<Map<String, Serializable>> res = RelationTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_DOCUMENTS_FOR_TAG.name(), session, label);
        if (res == null) {
            return Collections.emptyList();
        }
        return res.stream().map(m -> (String)m.get("relation:source")).collect(Collectors.toList());
    }

    @Override
    public Set<String> doGetTagSuggestions(CoreSession session, String label) {
        List<Map<String, Serializable>> res = RelationTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_TAG_SUGGESTIONS.name(), session, label);
        if (res == null) {
            return Collections.emptySet();
        }
        return res.stream().map(m -> (String)m.get("tag:label")).collect(Collectors.toSet());
    }

    @Override
    public boolean canUntag(CoreSession session, String docId, String label) {
        boolean canUntag = super.canUntag(session, docId, label);
        if (!canUntag) {
            UnrestrictedCanRemoveTagging r = new UnrestrictedCanRemoveTagging(session, docId, label);
            r.runUnrestricted();
            canUntag = r.canUntag;
        }
        return canUntag;
    }

    public List<Tag> getTagCloud(CoreSession session, String docId, String username, Boolean normalize) {
        UnrestrictedGetDocumentCloud r = new UnrestrictedGetDocumentCloud(session, docId, username, normalize);
        r.runUnrestricted();
        return r.cloud;
    }

    public static void normalizeCloud(List<Tag> cloud, int min, int max, boolean linear) {
        double diff;
        double nmin;
        if (min == max) {
            for (Tag tag : cloud) {
                tag.setWeight(100L);
            }
            return;
        }
        if (linear) {
            nmin = min;
            diff = max - min;
        } else {
            nmin = Math.log(min);
            diff = Math.log(max) - nmin;
        }
        for (Tag tag : cloud) {
            long weight = tag.getWeight();
            double norm = linear ? ((double)weight - nmin) / diff : (Math.log(weight) - nmin) / diff;
            tag.setWeight(Math.round(100.0 * norm));
        }
    }

    protected static class UnrestrictedGetDocumentCloud
    extends UnrestrictedSessionRunner {
        protected final String docId;
        protected final String username;
        protected final List<Tag> cloud;
        protected final Boolean normalize;

        protected UnrestrictedGetDocumentCloud(CoreSession session, String docId, String username, Boolean normalize) {
            super(session);
            this.docId = docId;
            this.username = AbstractTagService.cleanUsername(username);
            this.normalize = normalize;
            this.cloud = new ArrayList<Tag>();
        }

        public void run() {
            List<Map<String, Serializable>> res;
            if (this.docId == null) {
                res = this.username == null ? AbstractTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_ALL_TAGS.name(), this.session, new Object[0]) : AbstractTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_ALL_TAGS_FOR_USER.name(), this.session, this.username);
            } else {
                String path = this.session.getDocument((DocumentRef)new IdRef(this.docId)).getPathAsString();
                path = path.replace("'", "");
                ArrayList<String> docIds = new ArrayList<String>();
                docIds.add(this.docId);
                List<Map<String, Serializable>> docRes = AbstractTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_TAGGED_DOCUMENTS_UNDER.name(), this.session, path);
                if (docRes != null) {
                    for (Map<String, Serializable> map : docRes) {
                        docIds.add((String)((Object)map.get("ecm:uuid")));
                    }
                }
                res = this.username == null ? AbstractTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENTS.name(), this.session, docIds) : AbstractTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENTS_AND_USER.name(), this.session, docIds, this.username);
            }
            int min = 999999;
            int max = 0;
            if (res != null) {
                for (Map<String, Serializable> map : res) {
                    String label = (String)((Object)map.get("tag:label"));
                    int weight = ((Long)map.get("relation:source")).intValue();
                    if (weight == 0) continue;
                    if (weight > max) {
                        max = weight;
                    }
                    if (weight < min) {
                        min = weight;
                    }
                    Tag weightedTag = new Tag(label, weight);
                    this.cloud.add(weightedTag);
                }
            }
            if (this.normalize != null) {
                RelationTagService.normalizeCloud(this.cloud, min, max, this.normalize == false);
            }
        }
    }

    protected class UnrestrictedCanRemoveTagging
    extends UnrestrictedSessionRunner {
        private final String docId;
        private final String label;
        private boolean canUntag;

        protected UnrestrictedCanRemoveTagging(CoreSession session, String docId, String label) {
            super(session);
            this.docId = docId;
            this.label = RelationTagService.this.cleanLabel(label, true, false);
            this.canUntag = false;
        }

        public void run() {
            String tagId = null;
            if (this.label != null) {
                List<Map<String, Serializable>> res = AbstractTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_DOCUMENT_IDS_FOR_TAG.name(), this.session, this.label);
                String string = tagId = res != null && !res.isEmpty() ? (String)((Object)res.get(0).get("ecm:uuid")) : null;
                if (tagId == null) {
                    this.canUntag = true;
                    return;
                }
            }
            HashSet<String> creators = new HashSet<String>();
            Object query = String.format("SELECT DISTINCT dc:creator FROM Tagging WHERE relation:source = '%s'", this.docId);
            if (tagId != null) {
                query = (String)query + String.format(" AND relation:target = '%s'", tagId);
            }
            try (IterableQueryResult res = this.session.queryAndFetch((String)query, "NXQL", new Object[0]);){
                for (Map map : res) {
                    creators.add((String)map.get("dc:creator"));
                }
            }
            this.canUntag = creators.size() == 1 && creators.contains(this.originatingUsername);
        }
    }
}

