/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.Vec;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.LexicoDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicoDecoratorPB
extends LexicoDecorator<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private final List<ObjectiveFunction> objs = new ArrayList<ObjectiveFunction>();
    private BigInteger bigCurrentValue;

    public LexicoDecoratorPB(IPBSolver solver) {
        super((ISolver)solver);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addPseudoBoolean(lits, coeffs, moreThan, d);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        throw new UnsupportedOperationException();
    }

    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        ((IPBSolver)this.decorated()).setObjectiveFunction(this.objs.get(this.currentCriterion));
        return super.admitABetterSolution(assumps);
    }

    public void addCriterion(IVecInt literals) {
        this.objs.add(new ObjectiveFunction(literals, (IVec<BigInteger>)new Vec(literals.size(), (Object)BigInteger.ONE)));
    }

    public void addCriterion(IVecInt literals, IVec<BigInteger> coefs) {
        this.objs.add(new ObjectiveFunction(literals, coefs));
    }

    protected Number evaluate() {
        this.bigCurrentValue = this.objs.get(this.currentCriterion).calculateDegree(this);
        return this.bigCurrentValue;
    }

    protected void fixCriterionValue() throws ContradictionException {
        this.addPseudoBoolean(this.objs.get(this.currentCriterion).getVars(), this.objs.get(this.currentCriterion).getCoeffs(), true, this.bigCurrentValue);
        this.addPseudoBoolean(this.objs.get(this.currentCriterion).getVars(), this.objs.get(this.currentCriterion).getCoeffs(), false, this.bigCurrentValue);
    }

    protected IConstr discardSolutionsForOptimizing() throws ContradictionException {
        return this.addPseudoBoolean(this.objs.get(this.currentCriterion).getVars(), this.objs.get(this.currentCriterion).getCoeffs(), false, this.bigCurrentValue.subtract(BigInteger.ONE));
    }

    protected int numberOfCriteria() {
        return this.objs.size();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }
}

