/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.runtime.api.Framework;

public class CommentableDocumentAdapter
implements CommentableDocument {
    private static final long serialVersionUID = 2996381735762615450L;
    protected final DocumentModel docModel;
    protected final CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);

    public CommentableDocumentAdapter(DocumentModel docModel) {
        this.docModel = docModel;
    }

    @Override
    public DocumentModel addComment(DocumentModel comment) {
        return this.addComment(this.docModel, comment);
    }

    @Override
    public DocumentModel addComment(DocumentModel comment, String path) {
        comment.setPropertyValue("comment:parentId", (Serializable)((Object)this.docModel.getId()));
        return this.commentManager.createLocatedComment(this.docModel, comment, path);
    }

    @Override
    public DocumentModel addComment(DocumentModel parent, DocumentModel comment) {
        comment.setPropertyValue("comment:parentId", (Serializable)((Object)parent.getId()));
        return this.commentManager.createComment(parent, comment);
    }

    @Override
    public void removeComment(DocumentModel comment) {
        this.commentManager.deleteComment(this.docModel.getCoreSession(), comment.getId());
    }

    @Override
    public List<DocumentModel> getComments() {
        return this.getComments(this.docModel);
    }

    @Override
    public List<DocumentModel> getComments(DocumentModel parent) {
        CoreSession session = this.docModel.getCoreSession();
        List<Comment> comments = this.commentManager.getComments(session, parent.getId());
        return (List)CoreInstance.doPrivileged((CoreSession)session, s -> comments.stream().map(comment -> {
            DocumentModel commentModel = s.getDocument((DocumentRef)new IdRef(comment.getId()));
            commentModel.detach(true);
            return commentModel;
        }).collect(Collectors.toList()));
    }
}

