/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.el.ELService;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.core.BucketRange;
import org.nuxeo.ecm.platform.query.core.BucketRangeDate;
import org.nuxeo.ecm.platform.query.core.BucketTerm;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryAndFetchPageProvider;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class PageProviderHelper {
    private static final Logger log = LogManager.getLogger(PageProviderHelper.class);
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static PageProviderDefinition getQueryAndFetchProviderDefinition(String query) {
        return PageProviderHelper.getQueryAndFetchProviderDefinition(query, null);
    }

    public static PageProviderDefinition getQueryAndFetchProviderDefinition(String query, Map<String, String> properties) {
        QueryAndFetchProviderDescriptor desc = new QueryAndFetchProviderDescriptor();
        desc.setName("");
        desc.setPattern(query);
        if (properties != null) {
            desc.getProperties().putAll(properties);
        }
        return desc;
    }

    public static PageProviderDefinition getQueryPageProviderDefinition(String query) {
        return PageProviderHelper.getQueryPageProviderDefinition(query, null);
    }

    public static PageProviderDefinition getQueryPageProviderDefinition(String query, Map<String, String> properties) {
        return PageProviderHelper.getQueryPageProviderDefinition(query, properties, true, true);
    }

    public static PageProviderDefinition getQueryPageProviderDefinition(String query, Map<String, String> properties, boolean escapeParameters, boolean quoteParameters) {
        CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
        desc.setName("");
        desc.setPattern(query);
        desc.setEscapePatternParameters(escapeParameters);
        desc.setQuotePatternParameters(quoteParameters);
        if (properties != null) {
            desc.getProperties().putAll(properties);
        }
        return desc;
    }

    public static PageProviderDefinition getPageProviderDefinition(String providerName) {
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        return pageProviderService.getPageProviderDefinition(providerName);
    }

    public static PageProvider<?> getPageProvider(CoreSession session, PageProviderDefinition def, Map<String, String> namedParameters, Object ... queryParams) {
        return PageProviderHelper.getPageProvider(session, def, namedParameters, null, null, null, null, queryParams);
    }

    public static PageProvider<?> getPageProvider(CoreSession session, PageProviderDefinition def, Map<String, String> namedParameters, List<String> sortBy, List<String> sortOrder, Long pageSize, Long currentPageIndex, Object ... queryParams) {
        return PageProviderHelper.getPageProvider(session, def, namedParameters, sortBy, sortOrder, pageSize, currentPageIndex, null, null, queryParams);
    }

    public static PageProvider<?> getPageProvider(CoreSession session, PageProviderDefinition def, Map<String, String> namedParameters, List<String> sortBy, List<String> sortOrder, Long pageSize, Long currentPageIndex, List<String> highlights, List<String> quickFilters, Object ... parameters) {
        if (ArrayUtils.isNotEmpty((Object[])parameters)) {
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = session.getRepositoryName();
            }
        }
        ArrayList<SortInfo> sortInfos = null;
        if (sortBy != null) {
            sortInfos = new ArrayList<SortInfo>();
            for (int i = 0; i < sortBy.size(); ++i) {
                String sort = sortBy.get(i);
                if (!StringUtils.isNotBlank((CharSequence)sort)) continue;
                boolean sortAscending = sortOrder != null && !sortOrder.isEmpty() && ASC.equalsIgnoreCase(sortOrder.get(i).toLowerCase());
                sortInfos.add(new SortInfo(sort, sortAscending));
            }
        }
        ArrayList<QuickFilter> quickFilterList = null;
        if (quickFilters != null) {
            quickFilterList = new ArrayList<QuickFilter>();
            block2: for (String filter : quickFilters) {
                for (QuickFilter quickFilter : def.getQuickFilters()) {
                    if (!quickFilter.getName().equals(filter)) continue;
                    quickFilterList.add(quickFilter);
                    continue block2;
                }
            }
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)session);
        DocumentModel searchDocumentModel = PageProviderHelper.getSearchDocumentModel(session, def.getName(), namedParameters);
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        return pageProviderService.getPageProvider(def.getName(), def, searchDocumentModel, sortInfos, pageSize, currentPageIndex, props, highlights, quickFilterList, parameters);
    }

    public static DocumentModel getSearchDocumentModel(CoreSession session, String providerName, Map<String, String> namedParameters) {
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        return PageProviderHelper.getSearchDocumentModel(session, pageProviderService, providerName, namedParameters);
    }

    public static DocumentModel getSearchDocumentModel(CoreSession session, PageProviderService pps, String providerName, Map<String, String> namedParameters) {
        SimpleDocumentModel searchDocumentModel = null;
        if (StringUtils.isNotBlank((CharSequence)providerName)) {
            PageProviderDefinition def = pps.getPageProviderDefinition(providerName);
            if (def != null) {
                String searchDocType = def.getSearchDocumentType();
                if (searchDocType != null) {
                    searchDocumentModel = session.createDocumentModel(searchDocType);
                } else if (def.getWhereClause() != null) {
                    searchDocumentModel = SimpleDocumentModel.empty();
                }
            } else {
                log.error("No page provider definition found for provider: {}", (Object)providerName);
            }
        }
        if (namedParameters != null && !namedParameters.isEmpty()) {
            if (searchDocumentModel == null) {
                searchDocumentModel = SimpleDocumentModel.empty();
            }
            PageProviderHelper.fillSearchDocument(session, (DocumentModel)searchDocumentModel, namedParameters);
        }
        return searchDocumentModel;
    }

    protected static void fillSearchDocument(CoreSession session, @NotNull DocumentModel searchDoc, @NotNull Map<String, String> namedParameters) {
        Framework.doPrivileged(() -> {
            for (Map.Entry entry : namedParameters.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    DocumentHelper.setProperty(session, searchDoc, key, value, true);
                }
                catch (IOException | PropertyNotFoundException throwable) {}
            }
            searchDoc.putContextData("namedParameters", (Serializable)((Object)namedParameters));
        });
    }

    public static String buildQueryString(PageProvider<?> provider) {
        return PageProviderHelper.buildQueryStringWithPageProvider(provider, false);
    }

    public static String buildQueryStringWithAggregates(PageProvider<?> provider) {
        return PageProviderHelper.buildQueryStringWithPageProvider(provider, provider.hasAggregateSupport());
    }

    protected static String buildQueryStringWithPageProvider(PageProvider<?> provider, boolean useAggregates) {
        String query;
        String quickFiltersClause = "";
        List quickFilters = provider.getQuickFilters();
        if (quickFilters != null) {
            for (QuickFilter quickFilter : quickFilters) {
                String clause = quickFilter.getClause();
                if (!quickFiltersClause.isEmpty() && clause != null) {
                    quickFiltersClause = NXQLQueryBuilder.appendClause((String)quickFiltersClause, (String)clause);
                    continue;
                }
                quickFiltersClause = StringUtils.defaultString((String)clause);
            }
        }
        String aggregatesClause = useAggregates ? PageProviderHelper.buildAggregatesClause(provider) : null;
        PageProviderDefinition def = provider.getDefinition();
        WhereClauseDefinition whereClause = def.getWhereClause();
        DocumentModel searchDocumentModel = provider.getSearchDocumentModel();
        Object[] parameters = provider.getParameters();
        if (whereClause == null) {
            String pattern = def.getPattern();
            if (!quickFiltersClause.isEmpty()) {
                pattern = PageProviderHelper.appendToPattern(pattern, quickFiltersClause);
            }
            if (StringUtils.isNotEmpty((CharSequence)aggregatesClause)) {
                pattern = PageProviderHelper.appendToPattern(pattern, aggregatesClause);
            }
            query = NXQLQueryBuilder.getQuery((String)pattern, (Object[])parameters, (boolean)def.getQuotePatternParameters(), (boolean)def.getEscapePatternParameters(), (DocumentModel)searchDocumentModel, null);
        } else {
            if (searchDocumentModel == null) {
                throw new NuxeoException(String.format("Cannot build query of provider '%s': no search document model is set", provider.getName()));
            }
            String additionalClause = NXQLQueryBuilder.appendClause((String)aggregatesClause, (String)quickFiltersClause);
            query = NXQLQueryBuilder.getQuery((DocumentModel)searchDocumentModel, (WhereClauseDefinition)whereClause, (String)additionalClause, (Object[])parameters, null);
        }
        return query;
    }

    protected static String buildAggregatesClause(PageProvider provider) {
        try {
            Properties namedParameters = (Properties)provider.getSearchDocumentModel().getContextData("namedParameters");
            if (namedParameters == null) {
                return "";
            }
            Map aggregates = provider.getAggregates();
            Object aggregatesClause = "";
            for (Aggregate aggregate : aggregates.values()) {
                if (!namedParameters.containsKey(aggregate.getId())) continue;
                JsonNode node = OBJECT_MAPPER.readTree((String)namedParameters.get(aggregate.getId()));
                List keys = StreamSupport.stream(node.spliterator(), false).map(value -> value.asText().replaceAll("^\"|\"$", "")).collect(Collectors.toList());
                Object aggClause = aggregate.getBuckets().stream().filter(bucket -> keys.contains(bucket.getKey())).map(bucket -> PageProviderHelper.getClauseFromBucket(bucket, aggregate.getXPathField())).collect(Collectors.joining(" OR "));
                if (!StringUtils.isNotEmpty((CharSequence)aggClause)) continue;
                aggClause = "(" + (String)aggClause + ")";
                aggregatesClause = StringUtils.isEmpty((CharSequence)aggregatesClause) ? aggClause : NXQLQueryBuilder.appendClause((String)aggregatesClause, (String)aggClause);
            }
            return aggregatesClause;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected static String getClauseFromBucket(Bucket bucket, String field) {
        Object clause;
        field = field.replaceAll("\\.", "/");
        if (bucket instanceof BucketTerm) {
            clause = field + "='" + bucket.getKey() + "'";
        } else if (bucket instanceof BucketRange) {
            BucketRange bucketRange = (BucketRange)bucket;
            clause = PageProviderHelper.getRangeClause(field, bucketRange);
        } else if (bucket instanceof BucketRangeDate) {
            BucketRangeDate bucketRangeDate = (BucketRangeDate)bucket;
            clause = PageProviderHelper.getRangeDateClause(field, bucketRangeDate);
        } else {
            throw new NuxeoException("Unknown bucket instance for NXQL translation : " + bucket.getClass());
        }
        return clause;
    }

    protected static String getRangeClause(String field, BucketRange bucketRange) {
        Type type = ((SchemaManager)Framework.getService(SchemaManager.class)).getField(field).getType();
        Double from = bucketRange.getFrom() != null ? bucketRange.getFrom() : Double.NEGATIVE_INFINITY;
        Double to = bucketRange.getTo() != null ? bucketRange.getTo() : Double.POSITIVE_INFINITY;
        if (type instanceof IntegerType) {
            return field + " BETWEEN " + from.intValue() + " AND " + to.intValue();
        }
        if (type instanceof LongType) {
            return field + " BETWEEN " + from.longValue() + " AND " + to.longValue();
        }
        return field + " BETWEEN " + from + " AND " + to;
    }

    protected static String getRangeDateClause(String field, BucketRangeDate bucketRangeDate) {
        Double from = bucketRangeDate.getFrom();
        Double to = bucketRangeDate.getTo();
        if (from == null && to != null) {
            return field + " < TIMESTAMP '" + DateUtils.formatISODateTime((ZonedDateTime)DateUtils.nowIfNull((ZonedDateTime)bucketRangeDate.getToAsDate())) + "'";
        }
        if (from != null && to == null) {
            return field + " >= TIMESTAMP '" + DateUtils.formatISODateTime((ZonedDateTime)DateUtils.nowIfNull((ZonedDateTime)bucketRangeDate.getFromAsDate())) + "'";
        }
        return field + " BETWEEN TIMESTAMP '" + DateUtils.formatISODateTime((ZonedDateTime)DateUtils.nowIfNull((ZonedDateTime)bucketRangeDate.getFromAsDate())) + "' AND TIMESTAMP '" + DateUtils.formatISODateTime((ZonedDateTime)DateUtils.nowIfNull((ZonedDateTime)bucketRangeDate.getToAsDate())) + "'";
    }

    protected static String appendToPattern(String pattern, String clause) {
        return StringUtils.containsIgnoreCase((CharSequence)pattern, (CharSequence)" WHERE ") ? NXQLQueryBuilder.appendClause((String)pattern, (String)clause) : pattern + " WHERE " + clause;
    }

    public static Object[] resolveELParameters(PageProviderDefinition def, Object ... parameters) {
        ELService elService = (ELService)Framework.getService(ELService.class);
        if (elService == null) {
            return parameters;
        }
        String[] params = def.getQueryParameters();
        if (params == null) {
            params = new String[]{};
        }
        Object[] resolvedParams = new Object[params.length + (parameters != null ? parameters.length : 0)];
        ELContext elContext = elService.createELContext();
        int i = 0;
        if (parameters != null) {
            i = parameters.length;
            System.arraycopy(parameters, 0, resolvedParams, 0, i);
        }
        for (int j = 0; j < params.length; ++j) {
            ValueExpression ve = ELActionContext.EXPRESSION_FACTORY.createValueExpression(elContext, params[j], Object.class);
            resolvedParams[i + j] = ve.getValue(elContext);
        }
        return resolvedParams;
    }

    private PageProviderHelper() {
    }

    static final class QueryAndFetchProviderDescriptor
    extends GenericPageProviderDescriptor {
        private static final long serialVersionUID = 1L;

        public QueryAndFetchProviderDescriptor() {
            try {
                this.klass = Class.forName(CoreQueryAndFetchPageProvider.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

