/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl.jsongraph;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.impl.jsongraph.NodeView;
import org.nuxeo.ecm.platform.routing.core.impl.jsongraph.TransitionView;

public class JsonGraphRoute
extends UnrestrictedSessionRunner {
    private static Log log = LogFactory.getLog(JsonGraphRoute.class);
    protected String docId;
    protected GraphRoute graphRoute;
    protected Map<String, Object> graphElements;
    protected String json;
    protected Locale locale;

    public static Map<String, Object> getGraphElementsAsMap(GraphRoute route, Locale locale) {
        HashMap<String, Object> graph = new HashMap<String, Object>();
        ArrayList<NodeView> nodeViews = new ArrayList<NodeView>();
        ArrayList<TransitionView> tranViews = new ArrayList<TransitionView>();
        for (GraphNode node : route.getNodes()) {
            nodeViews.add(new NodeView(node, locale));
            List<GraphNode.Transition> transitions = node.getOutputTransitions();
            for (GraphNode.Transition transition : transitions) {
                GraphNode targetNode = route.getNode(transition.getTarget());
                tranViews.add(new TransitionView(node.getId(), targetNode.getId(), transition, locale));
            }
        }
        graph.put("nodes", nodeViews);
        graph.put("transitions", tranViews);
        return graph;
    }

    public static String getI18nLabel(String label, Locale locale) {
        if (label == null) {
            label = "";
        }
        try {
            return I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)locale);
        }
        catch (MissingResourceException e) {
            log.warn((Object)e.getMessage());
            return label;
        }
    }

    public JsonGraphRoute(CoreSession session, GraphRoute graphRoute, Locale locale) {
        super(session);
        this.graphRoute = graphRoute;
        this.locale = locale;
    }

    public JsonGraphRoute(CoreSession session, String docId, Locale locale) {
        super(session);
        this.docId = docId;
        this.locale = locale;
    }

    public Map<String, Object> getGraphElements() {
        if (this.graphElements == null) {
            this.runUnrestricted();
        }
        return this.graphElements;
    }

    public String getJSON() {
        if (this.json == null) {
            this.runUnrestricted();
        }
        return this.json;
    }

    public void run() {
        if (this.graphRoute == null) {
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            this.graphRoute = (GraphRoute)doc.getAdapter(GraphRoute.class);
        }
        try {
            this.graphElements = JsonGraphRoute.getGraphElementsAsMap(this.graphRoute, this.locale);
            ObjectMapper mapper = new ObjectMapper();
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, this.graphElements);
            this.json = writer.toString();
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public String toString() {
        return this.getJSON();
    }
}

