/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.persistence;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.service.extension.ExportedZipImporter;

public class RouteModelsZipImporter
extends ExportedZipImporter {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel createOrUpdate(FileImporterContext context) throws IOException {
        try (CloseableFile source = context.getBlob().getCloseableFile();){
            PathRef resultingRef;
            DocumentModel target;
            ZipFile zip = RouteModelsZipImporter.getArchiveFileIfValid((File)source.getFile());
            if (zip == null) {
                DocumentModel documentModel = null;
                return documentModel;
            }
            zip.close();
            boolean overWrite = false;
            NuxeoArchiveReader reader = new NuxeoArchiveReader(source.getFile());
            ExportedDocument root = reader.read();
            String parentPath = context.getParentPath();
            PathRef rootRef = new PathRef(parentPath, root.getPath().toString());
            ACP currentRouteModelACP = null;
            CoreSession session = context.getSession();
            if (session.exists((DocumentRef)rootRef) && (target = session.getDocument((DocumentRef)rootRef)).getPath().removeLastSegments(1).equals((Object)new Path(parentPath))) {
                overWrite = true;
                DocumentModel routeModel = session.getDocument((DocumentRef)rootRef);
                currentRouteModelACP = routeModel.getACP();
                session.removeDocument((DocumentRef)rootRef);
            }
            DocumentModelWriter writer = new DocumentModelWriter(session, parentPath, 10);
            reader.close();
            reader = new NuxeoArchiveReader(source.getFile());
            if (context.isOverwrite() && overWrite) {
                resultingRef = rootRef;
            } else {
                String rootName = root.getPath().lastSegment();
                resultingRef = new PathRef(parentPath, rootName);
            }
            try {
                DocumentPipeImpl pipe = new DocumentPipeImpl(10);
                pipe.setReader((DocumentReader)reader);
                pipe.setWriter((DocumentWriter)writer);
                pipe.run();
            }
            finally {
                reader.close();
                writer.close();
            }
            DocumentModel newRouteModel = session.getDocument((DocumentRef)resultingRef);
            if (currentRouteModelACP != null && context.isOverwrite() && overWrite) {
                newRouteModel.setACP(currentRouteModelACP, true);
            }
            DocumentModel documentModel = session.saveDocument(newRouteModel);
            return documentModel;
        }
    }
}

