/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoOAuth2ServiceProviderReader
extends EntityJsonReader<NuxeoOAuth2ServiceProvider> {
    public NuxeoOAuth2ServiceProviderReader() {
        super("nuxeoOAuth2ServiceProvider");
    }

    protected NuxeoOAuth2ServiceProvider readEntity(JsonNode jn) throws IOException {
        NuxeoOAuth2ServiceProvider provider = new NuxeoOAuth2ServiceProvider();
        provider.setServiceName(this.getStringField(jn, "serviceName"));
        provider.setDescription(this.getStringField(jn, "description"));
        provider.setClientId(this.getStringField(jn, "clientId"));
        provider.setClientSecret(this.getStringField(jn, "clientSecret"));
        provider.setAuthorizationServerURL(this.getStringField(jn, "authorizationServerURL"));
        provider.setTokenServerURL(this.getStringField(jn, "tokenServerURL"));
        provider.setUserAuthorizationURL(this.getStringField(jn, "userAuthorizationURL"));
        List scopes = this.getStringListField(jn, "scopes");
        provider.setScopes(scopes == null ? new String[]{} : scopes.toArray(new String[0]));
        Boolean enabled = this.getBooleanField(jn, "isEnabled");
        provider.setEnabled(enabled == null ? false : enabled);
        return provider;
    }
}

