/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.request;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.platform.oauth2.request.OAuth2Request;

public class TokenRequest
extends OAuth2Request {
    protected static final String BASIC_AUTHENTICATION_HEADER_PREFIX = "basic ";
    protected String grantType;
    protected String code;
    protected String clientSecret;
    protected String refreshToken;
    protected String codeVerifier;
    protected String assertion;

    public TokenRequest(HttpServletRequest request) {
        super(request);
        this.grantType = request.getParameter("grant_type");
        this.code = request.getParameter("code");
        this.clientSecret = request.getParameter("client_secret");
        this.refreshToken = request.getParameter("refresh_token");
        this.codeVerifier = request.getParameter("code_verifier");
        this.assertion = request.getParameter("assertion");
        this.checkAuthorization(request);
    }

    protected void checkAuthorization(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.toLowerCase().startsWith(BASIC_AUTHENTICATION_HEADER_PREFIX)) {
            String base64Credentials = authorization.substring(BASIC_AUTHENTICATION_HEADER_PREFIX.length()).trim();
            byte[] decodedCredentials = Base64.getDecoder().decode(base64Credentials);
            String credentials = new String(decodedCredentials, StandardCharsets.UTF_8);
            String[] values = credentials.split(":", 2);
            if (values.length == 2) {
                this.clientId = values[0];
                this.clientSecret = values[1];
            }
        }
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getCode() {
        return this.code;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public String getAssertion() {
        return this.assertion;
    }
}

