/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.util.ArrayList;

public class Path {
    public static final String[] EMPTY_SEGMENTS = new String[0];
    final String path;
    String[] segments;
    String attribute;

    public Path(String path) {
        this.path = path;
        this.parse(path);
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            return ((Path)obj).path.equals(this.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private void parse(String path) {
        int size;
        ArrayList<String> seg = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char[] chars = path.toCharArray();
        boolean attr = false;
        block4: for (char c : chars) {
            switch (c) {
                case '/': {
                    seg.add(sb.toString());
                    sb.setLength(0);
                    continue block4;
                }
                case '@': {
                    attr = true;
                    seg.add(sb.toString());
                    sb.setLength(0);
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            if (attr) {
                this.attribute = sb.toString();
            } else {
                seg.add(sb.toString());
            }
        }
        this.segments = (size = seg.size()) == 1 && ((String)seg.get(0)).length() == 0 ? EMPTY_SEGMENTS : seg.toArray(new String[size]);
    }
}

