/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.send.ComStmtPrepare;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.protocol.AbstractQueryProtocol;
import org.mariadb.jdbc.internal.protocol.AsyncMultiRead;
import org.mariadb.jdbc.internal.protocol.AsyncMultiReadResult;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.BulkStatus;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public abstract class AbstractMultiSend {
    protected int statementId = -1;
    protected ColumnType[] parameterTypeHeader;
    private final Protocol protocol;
    private final PacketOutputStream writer;
    private final Results results;
    private List<ParameterHolder[]> parametersList;
    private PrepareResult prepareResult;
    private List<String> queries;
    private final boolean binaryProtocol;
    private final boolean readPrepareStmtResult;
    private String sql;

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, ServerPrepareResult serverPrepareResult, List<ParameterHolder[]> parametersList, boolean readPrepareStmtResult, String sql) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.prepareResult = serverPrepareResult;
        this.parametersList = parametersList;
        this.binaryProtocol = true;
        this.readPrepareStmtResult = readPrepareStmtResult;
        this.sql = sql;
    }

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, ClientPrepareResult clientPrepareResult, List<ParameterHolder[]> parametersList) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.prepareResult = clientPrepareResult;
        this.parametersList = parametersList;
        this.binaryProtocol = false;
        this.readPrepareStmtResult = false;
    }

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, List<String> queries) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.queries = queries;
        this.binaryProtocol = false;
        this.readPrepareStmtResult = false;
    }

    public abstract void sendCmd(PacketOutputStream var1, Results var2, List<ParameterHolder[]> var3, List<String> var4, int var5, BulkStatus var6, PrepareResult var7) throws SQLException, IOException;

    public abstract SQLException handleResultException(SQLException var1, Results var2, List<ParameterHolder[]> var3, List<String> var4, int var5, int var6, int var7, PrepareResult var8);

    public abstract int getParamCount();

    public abstract int getTotalExecutionNumber();

    public PrepareResult getPrepareResult() {
        return this.prepareResult;
    }

    public PrepareResult executeBatch() throws SQLException {
        int paramCount = this.getParamCount();
        if (this.binaryProtocol) {
            if (this.readPrepareStmtResult) {
                this.parameterTypeHeader = new ColumnType[paramCount];
                if (this.prepareResult == null && this.protocol.getOptions().cachePrepStmts && this.protocol.getOptions().useServerPrepStmts) {
                    String key = this.protocol.getDatabase() + "-" + this.sql;
                    this.prepareResult = (PrepareResult)this.protocol.prepareStatementCache().get(key);
                    if (this.prepareResult != null && !((ServerPrepareResult)this.prepareResult).incrementShareCounter()) {
                        this.prepareResult = null;
                    }
                }
                this.statementId = this.prepareResult == null ? -1 : ((ServerPrepareResult)this.prepareResult).getStatementId();
            } else if (this.prepareResult != null) {
                this.statementId = ((ServerPrepareResult)this.prepareResult).getStatementId();
            }
        }
        return this.executeBatchStandard(paramCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private PrepareResult executeBatchStandard(int estimatedParameterCount) throws SQLException {
        int totalExecutionNumber = this.getTotalExecutionNumber();
        SQLException exception = null;
        BulkStatus status = new BulkStatus();
        ComStmtPrepare comStmtPrepare = null;
        FutureTask<AsyncMultiReadResult> futureReadTask = null;
        int paramCount = estimatedParameterCount;
        try {
            do {
                status.sendEnded = false;
                status.sendSubCmdCounter = 0;
                int requestNumberByBulk = Math.min(totalExecutionNumber - status.sendCmdCounter, this.protocol.getOptions().useBatchMultiSendNumber);
                this.protocol.changeSocketTcpNoDelay(false);
                if (this.readPrepareStmtResult && this.prepareResult == null) {
                    comStmtPrepare = new ComStmtPrepare(this.protocol, this.sql);
                    comStmtPrepare.send(this.writer);
                    this.prepareResult = comStmtPrepare.read(this.protocol.getReader(), this.protocol.isEofDeprecated());
                    this.statementId = ((ServerPrepareResult)this.prepareResult).getStatementId();
                    paramCount = this.getParamCount();
                }
                boolean useCurrentThread = false;
                while (status.sendSubCmdCounter < requestNumberByBulk) {
                    this.sendCmd(this.writer, this.results, this.parametersList, this.queries, paramCount, status, this.prepareResult);
                    ++status.sendSubCmdCounter;
                    ++status.sendCmdCounter;
                    if (useCurrentThread) {
                        try {
                            this.protocol.getResult(this.results);
                        }
                        catch (SQLException qex) {
                            if (this.readPrepareStmtResult) {
                                if (this.prepareResult == null) throw qex;
                            }
                            if (!this.protocol.getOptions().continueBatchOnError) {
                                throw qex;
                            }
                            exception = qex;
                        }
                        continue;
                    }
                    if (futureReadTask != null) continue;
                    try {
                        futureReadTask = new FutureTask<AsyncMultiReadResult>(new AsyncMultiRead(comStmtPrepare, status, this.protocol, false, this, paramCount, this.results, this.parametersList, this.queries, this.prepareResult));
                        if (AbstractQueryProtocol.readScheduler == null) {
                            Class<AbstractQueryProtocol> qex = AbstractQueryProtocol.class;
                            // MONITORENTER : org.mariadb.jdbc.internal.protocol.AbstractQueryProtocol.class
                            if (AbstractQueryProtocol.readScheduler == null) {
                                AbstractQueryProtocol.readScheduler = SchedulerServiceProviderHolder.getBulkScheduler();
                            }
                            // MONITOREXIT : qex
                        }
                        AbstractQueryProtocol.readScheduler.execute(futureReadTask);
                    }
                    catch (RejectedExecutionException r) {
                        useCurrentThread = true;
                        try {
                            this.protocol.getResult(this.results);
                        }
                        catch (SQLException qex) {
                            if (this.readPrepareStmtResult) {
                                if (this.prepareResult == null) throw qex;
                            }
                            if (!this.protocol.getOptions().continueBatchOnError) {
                                throw qex;
                            }
                            exception = qex;
                        }
                    }
                }
                status.sendEnded = true;
                if (!useCurrentThread) {
                    this.protocol.changeSocketTcpNoDelay(this.protocol.getOptions().tcpNoDelay);
                    try {
                        AsyncMultiReadResult asyncMultiReadResult = (AsyncMultiReadResult)futureReadTask.get();
                        if (this.binaryProtocol && this.prepareResult == null && asyncMultiReadResult.getPrepareResult() != null) {
                            this.prepareResult = asyncMultiReadResult.getPrepareResult();
                            this.statementId = ((ServerPrepareResult)this.prepareResult).getStatementId();
                            paramCount = this.prepareResult.getParamCount();
                        }
                        if (asyncMultiReadResult.getException() != null) {
                            if (this.readPrepareStmtResult) {
                                if (this.prepareResult == null) throw asyncMultiReadResult.getException();
                            }
                            if (!this.protocol.getOptions().continueBatchOnError) {
                                throw asyncMultiReadResult.getException();
                            }
                            exception = asyncMultiReadResult.getException();
                        }
                    }
                    catch (ExecutionException executionException) {
                        if (executionException.getCause() != null) throw new SQLException("Error reading results " + executionException.getCause().getMessage());
                        throw new SQLException("Error reading results " + executionException.getMessage());
                    }
                    catch (InterruptedException interruptedException) {
                        this.protocol.setActiveFutureTask(futureReadTask);
                        Thread.currentThread().interrupt();
                        throw new SQLException("Interrupted awaiting response ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), interruptedException);
                    }
                    finally {
                        this.protocol.forceReleaseWaitingPrepareStatement();
                    }
                }
                futureReadTask = null;
                if (!this.protocol.isInterrupted()) continue;
                throw new SQLTimeoutException("Timeout during batch execution");
            } while (status.sendCmdCounter < totalExecutionNumber);
            if (exception == null) return this.prepareResult;
            throw exception;
        }
        catch (IOException e) {
            throw this.protocol.handleIoException(e);
        }
    }
}

