/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelJsonReader
extends EntityJsonReader<DocumentModel> {
    private static final Logger log = LogManager.getLogger(DocumentModelJsonReader.class);
    public static final String LEGACY_MODE_READER = "DocumentModelLegacyModeReader";

    public DocumentModelJsonReader() {
        super("document");
    }

    @Override
    public DocumentModel read(Class<?> clazz, Type genericType, MediaType mediaType, InputStream in) throws IOException {
        Reader reader = (Reader)this.ctx.getParameter(LEGACY_MODE_READER);
        if (reader != null) {
            return (DocumentModel)reader.read(clazz, genericType, mediaType, in);
        }
        return (DocumentModel)super.read(clazz, genericType, mediaType, in);
    }

    @Override
    protected DocumentModel readEntity(JsonNode jn) throws IOException {
        DocumentModel doc = this.getDocument(jn);
        JsonNode propsNode = jn.get("properties");
        if (propsNode != null && !propsNode.isNull() && propsNode.isObject()) {
            ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
            List properties = (List)this.readEntity(List.class, genericType, propsNode);
            for (Property property : properties) {
                Framework.doPrivileged(() -> {
                    DocumentPart part = doc.getPart(property.getSchema().getName());
                    if (part != null) {
                        part.set(property.getName(), property);
                    }
                });
            }
        }
        return doc;
    }

    protected DocumentModel getDocument(JsonNode jn) throws IOException {
        String uid = this.getStringField(jn, "uid");
        if (StringUtils.isNotBlank((CharSequence)uid) && this.ctx != null) {
            try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(null);){
                DocumentModel doc = wrapper.getSession().getDocument((DocumentRef)new IdRef(uid));
                String changeToken = this.getStringField(jn, "changeToken");
                doc.putContextData("changeToken", (Serializable)((Object)changeToken));
                DocumentModel documentModel = doc;
                return documentModel;
            }
        }
        String type = this.getStringField(jn, "type");
        SimpleDocumentModel doc = StringUtils.isNotBlank((CharSequence)type) ? SimpleDocumentModel.ofType((String)type) : SimpleDocumentModel.empty();
        String name = this.getStringField(jn, "name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            doc.setPathInfo(null, name);
        }
        return doc;
    }

    public static void applyPropertyValues(DocumentModel src, DocumentModel dst) {
        DocumentModelJsonReader.applyPropertyValues(src, dst, true);
        dst.getContextData().putAll(src.getContextData());
    }

    public static void applyPropertyValues(DocumentModel src, DocumentModel dst, boolean dirtyOnly) {
        if (dirtyOnly) {
            DocumentModelJsonReader.applyDirtyPropertyValues(src, dst);
        } else {
            DocumentModelJsonReader.applyAllPropertyValues(src, dst);
        }
    }

    public static void applyDirtyPropertyValues(DocumentModel src, DocumentModel dst) {
        Stream.of(src.getSchemas()).flatMap(s -> src.getPropertyObjects(s).stream()).filter(Property::isDirty).forEach(p -> DocumentModelJsonReader.applyPropertyValue(p, dst));
    }

    public static void applyAllPropertyValues(DocumentModel src, DocumentModel dst) {
        SchemaManager service = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType type = service.getDocumentType(src.getType());
        Stream.of(type.getSchemaNames()).flatMap(s -> src.getPropertyObjects(s).stream()).forEach(p -> DocumentModelJsonReader.applyPropertyValue(p, dst));
    }

    protected static void applyPropertyValue(Property property, DocumentModel dst) {
        try {
            dst.setPropertyValue(DocumentModelJsonReader.getXPath(property), property.getValue());
        }
        catch (PropertyNotFoundException | ReadOnlyPropertyException e) {
            log.trace("Can't apply property: {} to dst: {}", (Object)property, (Object)dst, (Object)e);
        }
    }

    protected static String getXPath(Property property) {
        Object xpath = property.getXPath();
        if (!((String)xpath).contains(":")) {
            xpath = property.getSchema().getName() + ":" + (String)xpath;
        }
        return xpath;
    }

    @Deprecated(since="11.1")
    protected static void applyPropertyValue(DataModelImpl srcDataModel, DataModelImpl dstDataModel, String fieldName) {
        Serializable data = (Serializable)srcDataModel.getData(fieldName);
        try {
            dstDataModel.setData(fieldName, (Object)data);
        }
        catch (PropertyNotFoundException | ReadOnlyPropertyException e) {
            log.trace("Can't apply value: {} to src: {}", (Object)data, (Object)srcDataModel, (Object)e);
        }
    }
}

