/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.validation;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.core.api.validation.ConstraintViolation;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.api.validation.ValidationViolation;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentValidationReportJsonWriter
extends ExtensibleEntityJsonWriter<DocumentValidationReport> {
    public static final String ENTITY_TYPE = "validation_report";

    public DocumentValidationReportJsonWriter() {
        super(ENTITY_TYPE, DocumentValidationReport.class);
    }

    @Override
    protected void writeEntityBody(DocumentValidationReport report, JsonGenerator jg) throws IOException {
        jg.writeBooleanField("has_error", report.hasError());
        jg.writeNumberField("number", report.numberOfErrors());
        jg.writeArrayFieldStart("violations");
        for (ValidationViolation violation : report.asList()) {
            jg.writeStartObject();
            String messageKey = violation.getMessageKey();
            jg.writeStringField("messageKey", messageKey);
            if (violation instanceof ConstraintViolation) {
                ConstraintViolation cv = (ConstraintViolation)violation;
                String message = cv.getMessage(this.ctx.getLocale());
                jg.writeStringField("message", message);
                Object invalidValue = cv.getInvalidValue();
                if (invalidValue == null) {
                    jg.writeNullField("invalid_value");
                } else {
                    jg.writeStringField("invalid_value", invalidValue.toString());
                }
                Constraint constraint = cv.getConstraint();
                this.writeEntityField("constraint", constraint, jg);
                jg.writeArrayFieldStart("path");
                for (ConstraintViolation.PathNode node : cv.getPath()) {
                    jg.writeStartObject();
                    jg.writeStringField("field_name", node.getField().getName().getPrefixedName());
                    jg.writeBooleanField("is_list_item", node.isListItem());
                    if (node.isListItem()) {
                        jg.writeNumberField("index", node.getIndex());
                    }
                    jg.writeEndObject();
                }
                jg.writeEndArray();
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }
}

