/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.coldstorage;

import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.ecm.core.blob.ColdStorageHelper;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.MoveToColdStorage", category="Files", label="Move to Cold Storage", description="Move the main document content to the cold storage.")
public class MoveToColdStorage {
    private static final Logger log = LogManager.getLogger((String)"Document.MoveToColdStorage");
    public static final String ID = "Document.MoveToColdStorage";
    @Context
    protected CoreSession session;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod
    public DocumentModel run(DocumentModel document) {
        Blob thumbnail = ((ThumbnailService)Framework.getService(ThumbnailService.class)).getThumbnail(document, this.session);
        DocumentModel documentModel = ColdStorageHelper.moveContentToColdStorage((CoreSession)this.session, (DocumentRef)document.getRef());
        documentModel.setPropertyValue("file:content", (Serializable)thumbnail);
        if (this.save) {
            documentModel = this.session.saveDocument(documentModel);
        }
        return documentModel;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList documents) {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel documentModel : documents) {
            try {
                result.add((Object)this.run(documentModel));
            }
            catch (NuxeoException e) {
                log.error("Unable to move document: {} to cold storage", (Object)documentModel.getId(), (Object)e);
            }
        }
        return result;
    }
}

