/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;

@Operation(id="RunOperationOnProvider", category="Execution Flow", label="Run For Each Page", description="Run an operation for each page of the provider defined by the provider name, the operation input is the curent page ", aliases={"Context.RunOperationOnProvider"})
public class RunOperationOnProvider {
    public static final String ID = "RunOperationOnProvider";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"true"})
    protected boolean isolate = true;

    @OperationMethod
    public void run(PaginableDocumentModelListImpl paginableList) throws OperationException {
        PageProvider pageProvider = paginableList.getProvider();
        try (OperationContext subctx = this.ctx.getSubContext(this.isolate);){
            long initialRC = pageProvider.getResultsCount();
            long initialNoPages = pageProvider.getNumberOfPages();
            PaginableDocumentModelListImpl input = new PaginableDocumentModelListImpl(pageProvider);
            while (pageProvider.getCurrentPageIndex() < initialNoPages) {
                subctx.setInput((Object)input);
                this.service.run(subctx, this.chainId);
                if (!pageProvider.isNextPageAvailable()) {
                    break;
                }
                pageProvider.refresh();
                input = new PaginableDocumentModelListImpl(pageProvider);
                if (pageProvider.getResultsCount() != initialRC) continue;
                pageProvider.nextPage();
                input = new PaginableDocumentModelListImpl(pageProvider);
            }
        }
    }
}

