/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.api.login;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;

public class UserIdentificationInfo
implements Serializable {
    private static final long serialVersionUID = 6894397878763275157L;
    protected String userName;
    protected String password;
    protected boolean credentialsChecked;
    protected String token;
    protected String authPluginName;

    public UserIdentificationInfo(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new NuxeoException("username must not be blank");
        }
        this.userName = userName;
        this.credentialsChecked = true;
    }

    public UserIdentificationInfo(String userName, String password) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new NuxeoException("username must not be blank");
        }
        this.userName = userName;
        this.password = password;
    }

    public UserIdentificationInfo(UserIdentificationInfo savedIdent) {
        this(savedIdent.userName, savedIdent.password);
        this.credentialsChecked = savedIdent.credentialsChecked;
        this.token = savedIdent.token;
        this.authPluginName = savedIdent.authPluginName;
    }

    public String getAuthPluginName() {
        return this.authPluginName;
    }

    public void setAuthPluginName(String authPluginName) {
        this.authPluginName = authPluginName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new NuxeoException("username must not be blank");
        }
        this.userName = userName;
    }

    public boolean credentialsChecked() {
        return this.credentialsChecked;
    }

    public void setCredentialsChecked(boolean credentialsChecked) {
        this.credentialsChecked = credentialsChecked;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

