/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.path.PathTrie;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.DeprecationRestHandler;
import org.elasticsearch.rest.MethodHandlers;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.usage.UsageService;

public class RestController
extends AbstractComponent
implements HttpServerTransport.Dispatcher {
    private final PathTrie<MethodHandlers> handlers = new PathTrie(RestUtils.REST_DECODER);
    private final UnaryOperator<RestHandler> handlerWrapper;
    private final NodeClient client;
    private final CircuitBreakerService circuitBreakerService;
    private final Set<String> headersToCopy;
    private UsageService usageService;

    public RestController(Settings settings, Set<String> headersToCopy, UnaryOperator<RestHandler> handlerWrapper, NodeClient client, CircuitBreakerService circuitBreakerService, UsageService usageService) {
        super(settings);
        this.headersToCopy = headersToCopy;
        this.usageService = usageService;
        if (handlerWrapper == null) {
            handlerWrapper = h -> h;
        }
        this.handlerWrapper = handlerWrapper;
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
    }

    public void registerAsDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, String deprecationMessage, DeprecationLogger logger) {
        assert (!(handler instanceof DeprecationRestHandler));
        this.registerHandler(method, path, new DeprecationRestHandler(handler, deprecationMessage, logger));
    }

    public void registerWithDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, RestRequest.Method deprecatedMethod, String deprecatedPath, DeprecationLogger logger) {
        String deprecationMessage = "[" + deprecatedMethod.name() + " " + deprecatedPath + "] is deprecated! Use [" + method.name() + " " + path + "] instead.";
        this.registerHandler(method, path, handler);
        this.registerAsDeprecatedHandler(deprecatedMethod, deprecatedPath, handler, deprecationMessage, logger);
    }

    public void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        if (handler instanceof BaseRestHandler) {
            this.usageService.addRestHandler((BaseRestHandler)handler);
        }
        this.handlers.insertOrUpdate(path, new MethodHandlers(path, handler, method), (mHandlers, newMHandler) -> mHandlers.addMethods(handler, method));
    }

    public boolean canTripCircuitBreaker(Optional<RestHandler> handler) {
        return handler.map(h -> h.canTripCircuitBreaker()).orElse(true);
    }

    @Override
    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        if (request.rawPath().equals("/favicon.ico")) {
            this.handleFavicon(request, channel);
            return;
        }
        try {
            this.tryAllHandlers(request, channel, threadContext);
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new BytesRestResponse(channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
            }
        }
    }

    @Override
    public void dispatchBadRequest(RestRequest request, RestChannel channel, ThreadContext threadContext, Throwable cause) {
        try {
            Exception e = cause == null ? new ElasticsearchException("unknown cause", new Object[0]) : (cause instanceof Exception ? (Exception)cause : new ElasticsearchException(cause));
            channel.sendResponse(new BytesRestResponse(channel, RestStatus.BAD_REQUEST, e));
        }
        catch (IOException e) {
            if (cause != null) {
                e.addSuppressed(cause);
            }
            this.logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    boolean dispatchRequest(RestRequest request, RestChannel channel, NodeClient client, Optional<RestHandler> mHandler) throws Exception {
        boolean requestHandled;
        int contentLength = request.hasContent() ? request.content().length() : 0;
        RestChannel responseChannel = channel;
        if (contentLength > 0 && mHandler.map(h -> !RestController.hasContentType(request, h)).orElse(false).booleanValue()) {
            this.sendContentTypeErrorMessage(request, channel);
            requestHandled = true;
        } else if (contentLength > 0 && mHandler.map(h -> h.supportsContentStream()).orElse(false).booleanValue() && request.getXContentType() != XContentType.JSON && request.getXContentType() != XContentType.SMILE) {
            channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, "Content-Type [" + request.getXContentType() + "] does not support stream parsing. Use JSON or SMILE instead"));
            requestHandled = true;
        } else if (mHandler.isPresent()) {
            try {
                if (this.canTripCircuitBreaker(mHandler)) {
                    RestController.inFlightRequestsBreaker(this.circuitBreakerService).addEstimateBytesAndMaybeBreak(contentLength, "<http_request>");
                } else {
                    RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(contentLength);
                }
                responseChannel = new ResourceHandlingHttpChannel(channel, this.circuitBreakerService, contentLength);
                RestHandler wrappedHandler = mHandler.map(h -> (RestHandler)this.handlerWrapper.apply((RestHandler)h)).get();
                wrappedHandler.handleRequest(request, responseChannel, client);
                requestHandled = true;
            }
            catch (Exception e) {
                responseChannel.sendResponse(new BytesRestResponse(responseChannel, e));
                requestHandled = true;
            }
        } else {
            Set<RestRequest.Method> validMethodSet = this.getValidHandlerMethodSet(request);
            if (validMethodSet.size() > 0 && !validMethodSet.contains((Object)request.method()) && request.method() != RestRequest.Method.OPTIONS) {
                this.handleUnsupportedHttpMethod(request, channel, validMethodSet);
                requestHandled = true;
            } else if (!validMethodSet.contains((Object)request.method()) && request.method() == RestRequest.Method.OPTIONS) {
                this.handleOptionsRequest(request, channel, validMethodSet);
                requestHandled = true;
            } else {
                requestHandled = false;
            }
        }
        return requestHandled;
    }

    private static boolean hasContentType(RestRequest restRequest, RestHandler restHandler) {
        if (restRequest.getXContentType() == null) {
            String lowercaseMediaType;
            if (restHandler.supportsContentStream() && restRequest.header("Content-Type") != null && (lowercaseMediaType = restRequest.header("Content-Type").toLowerCase(Locale.ROOT)).equals("application/x-ndjson")) {
                restRequest.setXContentType(XContentType.JSON);
                return true;
            }
            return false;
        }
        return true;
    }

    private void sendContentTypeErrorMessage(RestRequest restRequest, RestChannel channel) throws IOException {
        List<String> contentTypeHeader = restRequest.getAllHeaderValues("Content-Type");
        String errorMessage = contentTypeHeader == null ? "Content-Type header is missing" : "Content-Type header [" + Strings.collectionToCommaDelimitedString(restRequest.getAllHeaderValues("Content-Type")) + "] is not supported";
        channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, errorMessage));
    }

    boolean checkErrorTraceParameter(RestRequest request, RestChannel channel) {
        return !request.paramAsBoolean("error_trace", false) || channel.detailedErrorsEnabled();
    }

    void tryAllHandlers(RestRequest request, RestChannel channel, ThreadContext threadContext) throws Exception {
        Optional<RestHandler> mHandler;
        Iterator<MethodHandlers> allHandlers;
        for (String key : this.headersToCopy) {
            String httpHeader = request.header(key);
            if (httpHeader == null) continue;
            threadContext.putHeader(key, httpHeader);
        }
        boolean requestHandled = false;
        if (!this.checkErrorTraceParameter(request, channel)) {
            channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.BAD_REQUEST, "error traces in responses are disabled."));
            return;
        }
        Iterator<MethodHandlers> it = allHandlers = this.getAllHandlers(request);
        while (it.hasNext() && !(requestHandled = this.dispatchRequest(request, channel, this.client, mHandler = Optional.ofNullable(it.next()).flatMap(mh -> mh.getHandler(request.method()))))) {
        }
        if (!requestHandled) {
            this.handleBadRequest(request, channel);
        }
    }

    Iterator<MethodHandlers> getAllHandlers(RestRequest request) {
        HashMap<String, String> originalParams = new HashMap<String, String>(request.params());
        return this.handlers.retrieveAll(this.getPath(request), () -> {
            request.params().clear();
            request.params().putAll(originalParams);
            return request.params();
        });
    }

    private void handleUnsupportedHttpMethod(RestRequest request, RestChannel channel, Set<RestRequest.Method> validMethodSet) {
        try {
            BytesRestResponse bytesRestResponse = BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.METHOD_NOT_ALLOWED, "Incorrect HTTP method for uri [" + request.uri() + "] and method [" + (Object)((Object)request.method()) + "], allowed: " + validMethodSet);
            bytesRestResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, ","));
            channel.sendResponse(bytesRestResponse);
        }
        catch (IOException e) {
            this.logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private void handleOptionsRequest(RestRequest request, RestChannel channel, Set<RestRequest.Method> validMethodSet) {
        if (request.method() == RestRequest.Method.OPTIONS && validMethodSet.size() > 0) {
            BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY);
            bytesRestResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, ","));
            channel.sendResponse(bytesRestResponse);
        } else if (request.method() == RestRequest.Method.OPTIONS && validMethodSet.size() == 0) {
            channel.sendResponse(new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private void handleBadRequest(RestRequest request, RestChannel channel) throws IOException {
        try (XContentBuilder builder = channel.newErrorBuilder();){
            builder.startObject();
            builder.field("error", "no handler found for uri [" + request.uri() + "] and method [" + (Object)((Object)request.method()) + "]");
            builder.endObject();
            channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
        }
    }

    private Set<RestRequest.Method> getValidHandlerMethodSet(RestRequest request) {
        Iterator<MethodHandlers> allHandlers;
        HashSet<RestRequest.Method> validMethods = new HashSet<RestRequest.Method>();
        Iterator<MethodHandlers> it = allHandlers = this.getAllHandlers(request);
        while (it.hasNext()) {
            Optional.ofNullable(it.next()).map(mh -> validMethods.addAll(mh.getValidMethods()));
        }
        return validMethods;
    }

    private String getPath(RestRequest request) {
        return request.rawPath();
    }

    void handleFavicon(RestRequest request, RestChannel channel) {
        if (request.method() == RestRequest.Method.GET) {
            try (InputStream stream = this.getClass().getResourceAsStream("/config/favicon.ico");){
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy((InputStream)stream, (OutputStream)out);
                BytesRestResponse restResponse = new BytesRestResponse(RestStatus.OK, "image/x-icon", out.toByteArray());
                channel.sendResponse(restResponse);
            }
            catch (IOException e) {
                channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
            }
        } else {
            channel.sendResponse(new BytesRestResponse(RestStatus.FORBIDDEN, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private static CircuitBreaker inFlightRequestsBreaker(CircuitBreakerService circuitBreakerService) {
        return circuitBreakerService.getBreaker("in_flight_requests");
    }

    private static final class ResourceHandlingHttpChannel
    implements RestChannel {
        private final RestChannel delegate;
        private final CircuitBreakerService circuitBreakerService;
        private final int contentLength;
        private final AtomicBoolean closed = new AtomicBoolean();

        ResourceHandlingHttpChannel(RestChannel delegate, CircuitBreakerService circuitBreakerService, int contentLength) {
            this.delegate = delegate;
            this.circuitBreakerService = circuitBreakerService;
            this.contentLength = contentLength;
        }

        @Override
        public XContentBuilder newBuilder() throws IOException {
            return this.delegate.newBuilder();
        }

        @Override
        public XContentBuilder newErrorBuilder() throws IOException {
            return this.delegate.newErrorBuilder();
        }

        @Override
        public XContentBuilder newBuilder(@Nullable XContentType xContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(xContentType, useFiltering);
        }

        @Override
        public BytesStreamOutput bytesOutput() {
            return this.delegate.bytesOutput();
        }

        @Override
        public RestRequest request() {
            return this.delegate.request();
        }

        @Override
        public boolean detailedErrorsEnabled() {
            return this.delegate.detailedErrorsEnabled();
        }

        @Override
        public void sendResponse(RestResponse response) {
            this.close();
            this.delegate.sendResponse(response);
        }

        private void close() {
            if (!this.closed.compareAndSet(false, true)) {
                throw new IllegalStateException("Channel is already closed");
            }
            RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(-this.contentLength);
        }
    }
}

