/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class PageProviderRegistry
extends ContributionFragmentRegistry<PageProviderDefinition> {
    private static final Log log = LogFactory.getLog(PageProviderRegistry.class);
    protected Map<String, PageProviderDefinition> providers = new HashMap<String, PageProviderDefinition>();

    public String getContributionId(PageProviderDefinition contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, PageProviderDefinition desc, PageProviderDefinition newOrigContrib) {
        String name = desc.getName();
        if (name == null) {
            log.error((Object)"Cannot register page provider without a name");
            return;
        }
        boolean enabled = desc.isEnabled();
        if (enabled) {
            log.info((Object)("Registering page provider with name " + name));
            this.providers.put(name, desc);
        } else {
            this.contributionRemoved(id, desc);
        }
    }

    public void contributionRemoved(String id, PageProviderDefinition origContrib) {
        this.providers.remove(id);
        log.info((Object)("Unregistering page provider with name " + id));
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public PageProviderDefinition clone(PageProviderDefinition orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(PageProviderDefinition src, PageProviderDefinition dst) {
        throw new UnsupportedOperationException();
    }

    public PageProviderDefinition getPageProvider(String id) {
        return this.providers.get(id);
    }
}

