/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;

public class ExportedZipImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = 1876876876L;
    private static final Log log = LogFactory.getLog(ExportedZipImporter.class);

    public static ZipFile getArchiveFileIfValid(File file) throws IOException {
        ZipFile zip;
        try {
            zip = new ZipFile(file);
        }
        catch (ZipException e) {
            log.debug((Object)"file is not a zipfile ! ", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.debug((Object)"can not open zipfile ! ", (Throwable)e);
            return null;
        }
        ZipEntry marker = zip.getEntry(".nuxeo-archive");
        if (marker == null) {
            zip.close();
            return null;
        }
        return zip;
    }

    @Override
    public boolean isOneToMany() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentModel createOrUpdate(FileImporterContext context) throws IOException {
        CoreSession session = context.getSession();
        Blob blob = context.getBlob();
        try (CloseableFile source = blob.getCloseableFile();){
            IdRef resultingRef;
            DocumentModel target;
            ZipFile zip = ExportedZipImporter.getArchiveFileIfValid(source.getFile());
            if (zip == null) {
                DocumentModel documentModel = null;
                return documentModel;
            }
            zip.close();
            boolean importWithIds = false;
            NuxeoArchiveReader reader = new NuxeoArchiveReader(source.getFile());
            ExportedDocument root = reader.read();
            IdRef rootRef = new IdRef(root.getId());
            String parentPath = context.getParentPath();
            if (session.exists((DocumentRef)rootRef) && (target = session.getDocument((DocumentRef)rootRef)).getPath().removeLastSegments(1).equals((Object)new Path(parentPath))) {
                importWithIds = true;
            }
            DocumentModelWriter writer = new DocumentModelWriter(session, parentPath, 10);
            reader.close();
            reader = new NuxeoArchiveReader(source.getFile());
            if (context.isOverwrite() && importWithIds) {
                resultingRef = rootRef;
            } else {
                String rootName = root.getPath().lastSegment();
                resultingRef = new PathRef(parentPath, rootName);
            }
            try {
                DocumentPipeImpl pipe = new DocumentPipeImpl(10);
                pipe.setReader((DocumentReader)reader);
                pipe.setWriter((DocumentWriter)writer);
                pipe.run();
            }
            catch (IOException e) {
                log.warn((Object)e, (Throwable)e);
            }
            finally {
                reader.close();
                writer.close();
            }
            DocumentModel documentModel = session.getDocument((DocumentRef)resultingRef);
            return documentModel;
        }
    }
}

