/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.ecm.platform.comment.service.CommentServiceHelper;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractCommentListener {
    private static final Log log = LogFactory.getLog(AbstractCommentListener.class);

    public void handleEvent(EventBundle events) {
        if (events.containsEventName("documentRemoved")) {
            for (Event event : events) {
                this.handleEvent(event);
            }
        }
    }

    public void handleEvent(Event event) {
        EventContext ctx;
        if ("documentRemoved".equals(event.getName()) && (ctx = event.getContext()) instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            CoreSession coreSession = docCtx.getCoreSession();
            CommentServiceConfig config = CommentServiceHelper.getCommentService().getConfig();
            RelationManager relationManager = (RelationManager)Framework.getService(RelationManager.class);
            this.doProcess(coreSession, relationManager, config, doc);
            return;
        }
    }

    protected void deleteCommentChildren(CoreSession coreSession, CommentManager commentManager, DocumentModel documentModel) {
        commentManager.getComments(coreSession, documentModel.getId()).forEach(comment -> coreSession.removeDocument((DocumentRef)new IdRef(comment.getId())));
    }

    protected abstract void doProcess(CoreSession var1, RelationManager var2, CommentServiceConfig var3, DocumentModel var4);
}

